/*
 * Decompiled with CFR 0.152.
 */
package ftools.bonitaet;

import ftools.bonitaet.Ertragstafelzeile;
import java.net.URL;
import java.util.List;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class BonitaetNachErtragstafel {
    Ertragstafelzeile etz = new Ertragstafelzeile(0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    Ertragstafelzeile[] et = new Ertragstafelzeile[1000];
    Ertragstafelzeile[] etx = new Ertragstafelzeile[50];
    int nEt = 0;

    public Ertragstafelzeile getErtragstafelzeile(URL url, int age, double suchh100, boolean oberhoehe) {
        int i;
        double eklalt = -99.0;
        double ekl = 0.0;
        int a = 0;
        double h = 0.0;
        double g = 0.0;
        double v = 0.0;
        double iv = 0.0;
        double gwl = 0.0;
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(url);
            DocType docType = doc.getDocType();
            Element Ertragstafel = doc.getRootElement();
            List zeilen = Ertragstafel.getChildren("Zeile");
            for (Element zeile : zeilen) {
                ekl = Double.parseDouble(zeile.getChild("Ertragsklasse").getText().trim());
                a = Integer.parseInt(zeile.getChild("Alter").getText().trim());
                h = 0.0;
                String htxt = "";
                htxt = oberhoehe ? zeile.getChild("H100").getText().trim() : zeile.getChild("Hg").getText().trim();
                if (htxt.length() > 0) {
                    h = Double.parseDouble(htxt);
                }
                g = 0.0;
                String gtxt = zeile.getChild("G").getText().trim();
                if (gtxt.length() > 0) {
                    g = Double.parseDouble(gtxt);
                }
                v = 0.0;
                String vtxt = zeile.getChild("V").getText().trim();
                if (vtxt.length() > 0) {
                    v = Double.parseDouble(vtxt);
                }
                iv = 0.0;
                String ivtxt = zeile.getChild("iV").getText().trim();
                if (ivtxt.length() > 0) {
                    iv = Double.parseDouble(ivtxt);
                }
                gwl = 0.0;
                String gwltxt = zeile.getChild("GWL").getText().trim();
                if (gwltxt.length() > 0) {
                    gwl = Double.parseDouble(gwltxt);
                }
                this.et[this.nEt] = new Ertragstafelzeile(a, ekl, h, g, v, iv, gwl);
                ++this.nEt;
            }
        }
        catch (Exception e) {
            System.out.println(url.toString() + " nicht gefunden !");
        }
        double[] klassen = new double[25];
        int nKlassen = 0;
        for (int i2 = 0; i2 < this.nEt; ++i2) {
            if (eklalt == this.et[i2].ekl) continue;
            klassen[nKlassen] = this.et[i2].ekl;
            eklalt = this.et[i2].ekl;
            ++nKlassen;
        }
        int hoeheVorhanden = 0;
        for (i = 0; i < this.nEt; ++i) {
            if (!(this.et[i].h100 > 0.0)) continue;
            ++hoeheVorhanden;
        }
        if (nKlassen > 1 && hoeheVorhanden > 1) {
            Ertragstafelzeile tempzeile;
            int k;
            for (k = 0; k < this.nEt - 1; ++k) {
                for (int m = k + 1; m < this.nEt; ++m) {
                    if (!(Math.abs((double)this.et[k].alter + 0.001 - (double)age) > Math.abs((double)this.et[m].alter + 0.001 - (double)age))) continue;
                    tempzeile = new Ertragstafelzeile(0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0);
                    tempzeile = this.et[k];
                    this.et[k] = this.et[m];
                    this.et[m] = tempzeile;
                }
            }
            for (i = 0; i < nKlassen; ++i) {
                int m = 0;
                int merk1 = 0;
                int merk2 = 0;
                for (int j = 0; j < this.nEt; ++j) {
                    if (this.et[j].ekl != klassen[i]) continue;
                    if (m == 0) {
                        merk1 = j;
                    }
                    if (m == 1) {
                        merk2 = j;
                    }
                    ++m;
                }
                this.etx[i] = new Ertragstafelzeile(0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                this.etx[i] = this.interpolationByAge(this.et[merk1], this.et[merk2], age);
            }
            for (k = 0; k < nKlassen - 1; ++k) {
                for (int m = k + 1; m < nKlassen; ++m) {
                    if (!(Math.abs(this.etx[k].h100 - suchh100) > Math.abs(this.etx[m].h100 - suchh100))) continue;
                    tempzeile = new Ertragstafelzeile(0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0);
                    tempzeile = this.etx[k];
                    this.etx[k] = this.etx[m];
                    this.etx[m] = tempzeile;
                }
            }
            this.etz = this.interpolationByH(this.etx[0], this.etx[1], suchh100);
        } else {
            this.etz.ekl = -9999.0;
        }
        return this.etz;
    }

    public Ertragstafelzeile getErtragstafelzeileByEkl(URL url, int age, double eklx, boolean oberhoehe) {
        int i;
        double eklalt = -99.0;
        double ekl = 0.0;
        int a = 0;
        double h = 0.0;
        double g = 0.0;
        double v = 0.0;
        double iv = 0.0;
        double gwl = 0.0;
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(url);
            DocType docType = doc.getDocType();
            Element Ertragstafel = doc.getRootElement();
            List zeilen = Ertragstafel.getChildren("Zeile");
            for (Element zeile : zeilen) {
                ekl = Double.parseDouble(zeile.getChild("Ertragsklasse").getText().trim());
                a = Integer.parseInt(zeile.getChild("Alter").getText().trim());
                h = 0.0;
                String htxt = "";
                htxt = oberhoehe ? zeile.getChild("H100").getText().trim() : zeile.getChild("Hg").getText().trim();
                if (htxt.length() > 0) {
                    h = Double.parseDouble(htxt);
                }
                g = 0.0;
                String gtxt = zeile.getChild("G").getText().trim();
                if (gtxt.length() > 0) {
                    g = Double.parseDouble(gtxt);
                }
                v = 0.0;
                String vtxt = zeile.getChild("V").getText().trim();
                if (vtxt.length() > 0) {
                    v = Double.parseDouble(vtxt);
                }
                iv = 0.0;
                String ivtxt = zeile.getChild("iV").getText().trim();
                if (ivtxt.length() > 0) {
                    iv = Double.parseDouble(ivtxt);
                }
                gwl = 0.0;
                String gwltxt = zeile.getChild("GWL").getText().trim();
                if (gwltxt.length() > 0) {
                    gwl = Double.parseDouble(gwltxt);
                }
                this.et[this.nEt] = new Ertragstafelzeile(a, ekl, h, g, v, iv, gwl);
                ++this.nEt;
            }
        }
        catch (Exception e) {
            System.out.println(url.toString() + " nicht gefunden !");
        }
        double[] klassen = new double[25];
        int nKlassen = 0;
        for (int i2 = 0; i2 < this.nEt; ++i2) {
            if (eklalt == this.et[i2].ekl) continue;
            klassen[nKlassen] = this.et[i2].ekl;
            eklalt = this.et[i2].ekl;
            ++nKlassen;
        }
        int hoeheVorhanden = 0;
        for (i = 0; i < this.nEt; ++i) {
            if (!(this.et[i].h100 > 0.0)) continue;
            ++hoeheVorhanden;
        }
        if (nKlassen > 1 && hoeheVorhanden > 1) {
            Ertragstafelzeile tempzeile;
            int k;
            for (k = 0; k < this.nEt - 1; ++k) {
                for (int m = k + 1; m < this.nEt; ++m) {
                    if (!(Math.abs((double)this.et[k].alter + 0.001 - (double)age) > Math.abs((double)this.et[m].alter + 0.001 - (double)age))) continue;
                    tempzeile = new Ertragstafelzeile(0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0);
                    tempzeile = this.et[k];
                    this.et[k] = this.et[m];
                    this.et[m] = tempzeile;
                }
            }
            for (i = 0; i < nKlassen; ++i) {
                int m = 0;
                int merk1 = 0;
                int merk2 = 0;
                for (int j = 0; j < this.nEt; ++j) {
                    if (this.et[j].ekl != klassen[i]) continue;
                    if (m == 0) {
                        merk1 = j;
                    }
                    if (m == 1) {
                        merk2 = j;
                    }
                    ++m;
                }
                this.etx[i] = new Ertragstafelzeile(0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                this.etx[i] = this.interpolationByAge(this.et[merk1], this.et[merk2], age);
            }
            for (k = 0; k < nKlassen - 1; ++k) {
                for (int m = k + 1; m < nKlassen; ++m) {
                    if (!(Math.abs(this.etx[k].ekl - eklx) > Math.abs(this.etx[m].ekl - eklx))) continue;
                    tempzeile = new Ertragstafelzeile(0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0);
                    tempzeile = this.etx[k];
                    this.etx[k] = this.etx[m];
                    this.etx[m] = tempzeile;
                }
            }
            this.etz = this.interpolationByEkl(this.etx[0], this.etx[1], eklx);
            this.etz.ekl = eklx;
        } else {
            this.etz.ekl = -9999.0;
        }
        return this.etz;
    }

    public double getHoeheByAgeAndEkl(int age, double eklx) {
        int i;
        Ertragstafelzeile tempzeile;
        int m;
        int k;
        double eklalt = -99.0;
        double suchHoehe = 0.0;
        for (k = 0; k < this.nEt - 1; ++k) {
            for (m = k + 1; m < this.nEt; ++m) {
                if (this.et[k].alter <= this.et[m].alter) continue;
                tempzeile = new Ertragstafelzeile(0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0);
                tempzeile = this.et[k];
                this.et[k] = this.et[m];
                this.et[m] = tempzeile;
            }
        }
        for (k = 0; k < this.nEt - 1; ++k) {
            for (m = k + 1; m < this.nEt; ++m) {
                if (!(this.et[k].ekl > this.et[m].ekl)) continue;
                tempzeile = new Ertragstafelzeile(0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0);
                tempzeile = this.et[k];
                this.et[k] = this.et[m];
                this.et[m] = tempzeile;
            }
        }
        double[] klassen = new double[25];
        int nKlassen = 0;
        for (int i2 = 0; i2 < this.nEt; ++i2) {
            if (eklalt == this.et[i2].ekl) continue;
            klassen[nKlassen] = this.et[i2].ekl;
            eklalt = this.et[i2].ekl;
            ++nKlassen;
        }
        int hoeheVorhanden = 0;
        for (i = 0; i < this.nEt; ++i) {
            if (!(this.et[i].h100 > 0.0)) continue;
            ++hoeheVorhanden;
        }
        if (nKlassen > 1 && hoeheVorhanden > 1) {
            int m2;
            int k2;
            for (k2 = 0; k2 < this.nEt - 1; ++k2) {
                for (m2 = k2 + 1; m2 < this.nEt; ++m2) {
                    if (!(Math.abs((double)this.et[k2].alter + 0.001 - (double)age) > Math.abs((double)this.et[m2].alter + 0.001 - (double)age))) continue;
                    Ertragstafelzeile tempzeile2 = new Ertragstafelzeile(0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0);
                    tempzeile2 = this.et[k2];
                    this.et[k2] = this.et[m2];
                    this.et[m2] = tempzeile2;
                }
            }
            for (i = 0; i < nKlassen; ++i) {
                m2 = 0;
                int merk1 = 0;
                int merk2 = 0;
                for (int j = 0; j < this.nEt; ++j) {
                    if (this.et[j].ekl != klassen[i]) continue;
                    if (m2 == 0) {
                        merk1 = j;
                    }
                    if (m2 == 1) {
                        merk2 = j;
                    }
                    ++m2;
                }
                this.etx[i] = new Ertragstafelzeile(0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                this.etx[i] = this.interpolationByAge(this.et[merk1], this.et[merk2], age);
            }
            for (k2 = 0; k2 < nKlassen - 1; ++k2) {
                for (m2 = k2 + 1; m2 < nKlassen; ++m2) {
                    if (!(Math.abs(this.etx[k2].ekl - eklx) > Math.abs(this.etx[m2].ekl - eklx))) continue;
                    Ertragstafelzeile tempzeile3 = new Ertragstafelzeile(0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0);
                    tempzeile3 = this.etx[k2];
                    this.etx[k2] = this.etx[m2];
                    this.etx[m2] = tempzeile3;
                }
            }
            this.etz = this.interpolationByEkl(this.etx[0], this.etx[1], eklx);
            suchHoehe = this.etz.h100;
        } else {
            suchHoehe = -9999.0;
        }
        return suchHoehe;
    }

    public Ertragstafelzeile interpolationByAge(Ertragstafelzeile z1, Ertragstafelzeile z2, int age) {
        Ertragstafelzeile interpol = new Ertragstafelzeile(age, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        interpol.h100 = z1.h100 - (z1.h100 - z2.h100) * (1.0 * (double)(z1.alter - age) / (1.0 * (double)(z1.alter - z2.alter)));
        interpol.gha = z1.gha - (z1.gha - z2.gha) * (1.0 * (double)(z1.alter - age) / (1.0 * (double)(z1.alter - z2.alter)));
        interpol.vha = z1.vha - (z1.vha - z2.vha) * (1.0 * (double)(z1.alter - age) / (1.0 * (double)(z1.alter - z2.alter)));
        interpol.ivha = z1.ivha - (z1.ivha - z2.ivha) * (1.0 * (double)(z1.alter - age) / (1.0 * (double)(z1.alter - z2.alter)));
        interpol.gwl = z1.gwl - (z1.gwl - z2.gwl) * (1.0 * (double)(z1.alter - age) / (1.0 * (double)(z1.alter - z2.alter)));
        interpol.ekl = z1.ekl;
        if (age > z1.alter && age > z2.alter) {
            interpol.extrapoliert = true;
        }
        if (age < z1.alter && age < z2.alter) {
            interpol.extrapoliert = true;
        }
        return interpol;
    }

    public Ertragstafelzeile interpolationByH(Ertragstafelzeile z1, Ertragstafelzeile z2, double hoehe) {
        Ertragstafelzeile interpol = new Ertragstafelzeile(0, 0.0, hoehe, 0.0, 0.0, 0.0, 0.0);
        interpol.ekl = z1.ekl - (z1.ekl - z2.ekl) * (1.0 * (z1.h100 - hoehe) / (1.0 * (z1.h100 - z2.h100)));
        interpol.gha = z1.gha - (z1.gha - z2.gha) * (1.0 * (z1.h100 - hoehe) / (1.0 * (z1.h100 - z2.h100)));
        interpol.vha = z1.vha - (z1.vha - z2.vha) * (1.0 * (z1.h100 - hoehe) / (1.0 * (z1.h100 - z2.h100)));
        interpol.ivha = z1.ivha - (z1.ivha - z2.ivha) * (1.0 * (z1.h100 - hoehe) / (1.0 * (z1.h100 - z2.h100)));
        interpol.gwl = z1.gwl - (z1.gwl - z2.gwl) * (1.0 * (z1.h100 - hoehe) / (1.0 * (z1.h100 - z2.h100)));
        interpol.alter = z1.alter;
        if (hoehe > z1.h100 && hoehe > z2.h100) {
            interpol.extrapoliert = true;
        }
        if (hoehe < z1.h100 && hoehe < z2.h100) {
            interpol.extrapoliert = true;
        }
        if (z1.extrapoliert || z2.extrapoliert) {
            interpol.extrapoliert = true;
        }
        return interpol;
    }

    private Ertragstafelzeile interpolationByEkl(Ertragstafelzeile z1, Ertragstafelzeile z2, double eklx) {
        Ertragstafelzeile interpol = new Ertragstafelzeile(0, 0.0, eklx, 0.0, 0.0, 0.0, 0.0);
        interpol.h100 = z1.h100 - (z1.h100 - z2.h100) * (1.0 * (z1.ekl - eklx) / (1.0 * (z1.ekl - z2.ekl)));
        interpol.gha = z1.gha - (z1.gha - z2.gha) * (1.0 * (z1.ekl - eklx) / (1.0 * (z1.ekl - z2.ekl)));
        interpol.vha = z1.vha - (z1.vha - z2.vha) * (1.0 * (z1.ekl - eklx) / (1.0 * (z1.ekl - z2.ekl)));
        interpol.ivha = z1.ivha - (z1.ivha - z2.ivha) * (1.0 * (z1.ekl - eklx) / (1.0 * (z1.ekl - z2.ekl)));
        interpol.gwl = z1.gwl - (z1.gwl - z2.gwl) * (1.0 * (z1.ekl - eklx) / (1.0 * (z1.ekl - z2.ekl)));
        interpol.alter = z1.alter;
        if (eklx > z1.ekl && eklx > z2.ekl) {
            interpol.extrapoliert = true;
        }
        if (eklx < z1.ekl && eklx < z2.ekl) {
            interpol.extrapoliert = true;
        }
        if (z1.extrapoliert || z2.extrapoliert) {
            interpol.extrapoliert = true;
        }
        return interpol;
    }
}

