/*
 * Decompiled with CFR 0.152.
 */
package treegross.base;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import treegross.base.Species;
import treegross.base.SpeciesNotDefinedException;
import treegross.base.Stand;

public class DataExchangeFormat {
    private static final Logger LOGGER = Logger.getLogger(DataExchangeFormat.class.getName());
    public double targetDiameter;
    public double targetDiameterLayer;
    public double targetAgeLayer;
    public double targetCrownPercent;
    public double minCropTreeHeight;
    public double maxAge;
    public int numberCropTreesWanted;
    public int targetRang;
    public double thinningIntensity;

    public void save(Stand st, String fn) {
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(fn)));){
            int i;
            int pm = 0;
            NumberFormat f = NumberFormat.getInstance(new Locale("en", "US"));
            f.setMaximumFractionDigits(2);
            f.setMinimumFractionDigits(2);
            Date datum = new Date();
            out.println("TreeGrOSS Exchange Data :" + datum + " by Waldplaner2");
            out.println(st.standname);
            out.println(st.year + ";Jahr");
            out.println(st.size + ";Flaechengroesse ha");
            out.println(st.ncpnt + ";Eckpunkte");
            out.println("No;x;y;z;");
            for (i = 0; i < st.ncpnt; ++i) {
                out.println(st.cpnt[i].no + ";" + f.format(st.cpnt[i].x) + ";" + f.format(st.cpnt[i].y) + ";" + f.format(st.cpnt[i].z) + ";");
            }
            int rge = st.random.getRandomType();
            out.println(rge + ";Zufallseffekte Wachstum");
            int dd = 0;
            if (st.distanceDependent) {
                dd = 1;
            }
            out.println(dd + ";Distanzabh\u00e4ngigkeit");
            int ia = 0;
            if (st.ingrowthActive) {
                ia = 1;
            }
            out.println(ia + ";Einwuchs an");
            out.println(st.trule.treatmentType + ";Behandlungstyp");
            out.println(st.trule.maxHarvestVolume + ";Maximales Erntevolumen");
            out.println(st.trule.minHarvestVolume + ";Minimales Erntevolumen");
            out.println(st.trule.maxThinningVolume + ";Maximales Durchforstungsvolumen");
            out.println(st.trule.minThinningVolume + ";Minimales Durchforstungsvolumen");
            out.println(st.trule.minOutVolume + ";Minimales Entnahmevolumen (Ernte+Durchforstung)");
            out.println(st.trule.maxOutVolume + ";Maximales Entnahmevolumen (Ernte+Durchforstung)");
            out.println(st.trule.standType + ";StandType");
            out.println(st.trule.targetType + ";TargetType");
            out.println(st.trule.nHabitat + ";Anzahl der Habitatb\u00e4ume");
            out.println(st.trule.treatmentStep + ";Jahre zwischen den Eingriffen");
            out.println(st.trule.harvestingYears + ";Endnutzung startete vor x Jahren");
            out.println(st.trule.maxHarvestingPeriode + ";Endnutzungszeitraum maximal X Jahre");
            if (st.trule.harvestLayerFromBelow) {
                pm = 1;
            }
            out.println(pm + ";1-> Endnutzung einer zielstarken schicht von unten, 0-> Endnutzung einer zielstarken schicht von oben");
            if (st.trule.selectCropTrees) {
                pm = 1;
            }
            out.println(pm + ";1-> Z-Baumauswahl an, 0-> Z-Baumauswahl aus");
            if (st.trule.reselectCropTrees) {
                pm = 1;
            }
            out.println(pm + ";1-> Z-Baumnachwahl an, 0-> Z-Baumnachauswahl aus");
            if (st.trule.selectCropTreesOfAllSpecies) {
                pm = 1;
            }
            out.println(pm + ";1-> Z-B\u00e4ume auch von Arten, die nicht dem Zieltyp entsprechen, 0-> Z-B\u00e4ume nur von Arten, die dem Zieltyp entsprechen");
            if (st.trule.releaseCropTrees) {
                pm = 1;
            }
            out.println(pm + ";1-> Z-Baumfreistellung an, 0-> Z-Baumfreistellung aus");
            if (st.trule.releaseCropTreesSpeciesDependent) {
                pm = 1;
            }
            out.println(pm + ";1-> Z-Baumfreistellung entsprechend des Zieltyps, 0-> Z-Baumfreistellung entsprechend der Bedr\u00e4ngungssituation");
            if (st.trule.cutCompetingCropTrees) {
                pm = 1;
            }
            out.println(pm + ";1-> Entnahme von sich bedr\u00e4ngenden Z-B\u00e4umen, 0-> keine Entnahme von sich bedr\u00e4ngenden Z-B\u00e4umen");
            if (st.trule.thinArea) {
                pm = 1;
            }
            out.println(pm + ";1-> Durchforstung der Zwischenr\u00e4ume an, 0-> Durchforstung der Zwischenr\u00e4ume aus");
            if (st.trule.thinAreaSpeciesDependent) {
                pm = 1;
            }
            out.println(pm + ";1-> Durchforstung der Zwischenr\u00e4ume entsprechend des Zieltyps an, 0-> Durchforstung der Zwischenr\u00e4ume entsprechend der Bedr\ufffdngungssituation");
            out.println(st.trule.thinningIntensityArea + ";Freistellungsgrad der Zwischenr\u00e4ume");
            out.println(st.trule.typeOfHarvest + ";Art der Endnutzung (0=Zielst\u00e4rke, 1=Dg, 2=Alter");
            out.println(st.trule.lastTreatment + ";Die letzte Ma\u00dfnahme wurde im Jahr X ausgef\u00fchrt");
            if (st.trule.selectHabiatPart) {
                pm = 1;
            }
            out.println(pm + "; f\u00fcr eine Resthabitatbaumanzahl <0 wird ein weiterer Habitatbaum selektiert");
            if (st.trule.protectMinorities) {
                pm = 1;
            }
            out.println(pm + ";Schutz von Minderheiten");
            out.println(st.nspecies + ";Anzahl Arten");
            for (int a = 0; a < st.nspecies - 1; ++a) {
                for (int b = a + 1; b < st.nspecies; ++b) {
                    if (!(st.sp[a].trule.targetCrownPercent < st.sp[b].trule.targetCrownPercent)) continue;
                    Species sptemp = st.sp[a];
                    st.sp[a] = st.sp[b];
                    st.sp[b] = sptemp;
                }
            }
            for (int n = 0; n < st.nspecies; ++n) {
                out.println(st.sp[n].code + ";Baumart " + n);
                out.println(st.sp[n].trule.thinningIntensity + ";Freistellungsgrad Baumart " + n);
                out.println(st.sp[n].trule.targetDiameter + ";Zieldurchmesser Baumart " + n);
                out.println(st.sp[n].trule.targetDiameterLayer + ";Zieldurchmesser Baumschicht " + n);
                out.println(st.sp[n].trule.targetAgeLayer + ";Zielalter Baumschicht " + n);
                out.println(st.sp[n].trule.targetCrownPercent + ";Zielprozent Baumart " + n);
                out.println(st.sp[n].trule.minCropTreeHeight + ";Mindesth\u00f6he Durchforstung Baumart " + n);
                out.println(st.sp[n].trule.maxAge + ";Maximales Alter Baumart " + n);
                out.println(st.sp[n].trule.numberCropTreesWanted + ";Anzahl Z-B\u00e4ume/ha" + n);
                out.println(st.sp[n].trule.targetRang + ";Rang der Art im Zielbestand" + n);
            }
            out.println("Code;N;No;Age;DBH;Height;Site index;Crown Base;Crown width;alive;Removal Code;x-Coord.;y-Coord.;z-Coord.;Crop tree; Temp Crop tree, Habitat tree");
            for (i = 0; i < st.ntrees; ++i) {
                if ("".equals(st.tr[i].no)) {
                    st.tr[i].no = " ";
                }
                int zb = 0;
                int tzb = 0;
                int hb = 0;
                if (st.tr[i].crop) {
                    zb = 1;
                }
                if (st.tr[i].tempcrop) {
                    tzb = 1;
                }
                if (st.tr[i].habitat) {
                    hb = 1;
                }
                out.println(st.tr[i].code + ";1;" + st.tr[i].no + ";" + st.tr[i].age + ";" + f.format(st.tr[i].d) + ";" + f.format(st.tr[i].h) + ";" + f.format(st.tr[i].si) + ";" + f.format(st.tr[i].cb) + ";" + f.format(st.tr[i].cw) + ";" + st.tr[i].out + ";" + st.tr[i].outtype + ";" + f.format(st.tr[i].x) + ";" + f.format(st.tr[i].y) + ";" + f.format(st.tr[i].z) + ";" + zb + ";" + tzb + ";" + hb);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.SEVERE, "treegross", e);
        }
    }

    public void read(Stand st, String fn) {
        try {
            int i;
            st.newStand();
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(fn)));
            in.readLine();
            st.addName(in.readLine());
            String s = in.readLine();
            String delim = ";";
            StringTokenizer stx = new StringTokenizer(s, delim);
            st.year = Integer.parseInt(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.addsize(Double.parseDouble(stx.nextToken()));
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            int nx = Integer.parseInt(stx.nextToken());
            in.readLine();
            for (int ii = 0; ii < nx; ++ii) {
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                st.addcornerpoint(stx.nextToken(), Double.parseDouble(stx.nextToken()), Double.parseDouble(stx.nextToken()), Double.parseDouble(stx.nextToken()));
            }
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            int rge = Integer.parseInt(stx.nextToken());
            if (rge == 1) {
                st.random.setRandomType(11);
            } else if (rge == 0) {
                st.random.setRandomType(10);
            } else {
                st.random.setRandomType(rge);
            }
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            int dd = Integer.parseInt(stx.nextToken());
            st.distanceDependent = dd == 1;
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            int ia = Integer.parseInt(stx.nextToken());
            st.ingrowthActive = ia == 1;
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.treatmentType = Integer.parseInt(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.maxHarvestVolume = Double.parseDouble(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.minHarvestVolume = Double.parseDouble(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.maxThinningVolume = Double.parseDouble(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.minThinningVolume = Double.parseDouble(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.minOutVolume = Double.parseDouble(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.maxOutVolume = Double.parseDouble(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.standType = Integer.parseInt(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.targetType = Integer.parseInt(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.nHabitat = Double.parseDouble(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.treatmentStep = Integer.parseInt(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.harvestingYears = Integer.parseInt(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.maxHarvestingPeriode = Integer.parseInt(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            int pm = Integer.parseInt(stx.nextToken());
            st.trule.harvestLayerFromBelow = pm == 1;
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            pm = Integer.parseInt(stx.nextToken());
            if (pm == 1) {
                st.trule.selectCropTrees = true;
            } else {
                st.trule.harvestLayerFromBelow = false;
            }
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            pm = Integer.parseInt(stx.nextToken());
            if (pm == 1) {
                st.trule.reselectCropTrees = true;
            } else {
                st.trule.harvestLayerFromBelow = false;
            }
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            pm = Integer.parseInt(stx.nextToken());
            if (pm == 1) {
                st.trule.selectCropTreesOfAllSpecies = true;
            } else {
                st.trule.harvestLayerFromBelow = false;
            }
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            pm = Integer.parseInt(stx.nextToken());
            if (pm == 1) {
                st.trule.releaseCropTrees = true;
            } else {
                st.trule.harvestLayerFromBelow = false;
            }
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            pm = Integer.parseInt(stx.nextToken());
            if (pm == 1) {
                st.trule.releaseCropTreesSpeciesDependent = true;
            } else {
                st.trule.harvestLayerFromBelow = false;
            }
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            pm = Integer.parseInt(stx.nextToken());
            if (pm == 1) {
                st.trule.cutCompetingCropTrees = true;
            } else {
                st.trule.harvestLayerFromBelow = false;
            }
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            pm = Integer.parseInt(stx.nextToken());
            if (pm == 1) {
                st.trule.thinArea = true;
            } else {
                st.trule.harvestLayerFromBelow = false;
            }
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            pm = Integer.parseInt(stx.nextToken());
            if (pm == 1) {
                st.trule.thinAreaSpeciesDependent = true;
            } else {
                st.trule.harvestLayerFromBelow = false;
            }
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.thinningIntensityArea = Double.parseDouble(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.typeOfHarvest = Integer.parseInt(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.lastTreatment = Integer.parseInt(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            pm = Integer.parseInt(stx.nextToken());
            if (pm == 1) {
                st.trule.selectHabiatPart = true;
            } else {
                st.trule.harvestLayerFromBelow = false;
            }
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            pm = Integer.parseInt(stx.nextToken());
            st.trule.protectMinorities = pm == 1;
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            int nspecies = Integer.parseInt(stx.nextToken());
            int[] codeSp = new int[nspecies];
            double[] tISp = new double[nspecies];
            double[] tdSp = new double[nspecies];
            double[] tdlSp = new double[nspecies];
            double[] talSp = new double[nspecies];
            double[] tcpSp = new double[nspecies];
            double[] cthSp = new double[nspecies];
            double[] maxAgeSp = new double[nspecies];
            int[] nCT = new int[nspecies];
            int[] tR = new int[nspecies];
            for (i = 0; i < nspecies; ++i) {
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                codeSp[i] = Integer.parseInt(stx.nextToken());
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                tISp[i] = Double.parseDouble(stx.nextToken());
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                tdSp[i] = Double.parseDouble(stx.nextToken());
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                tdlSp[i] = Double.parseDouble(stx.nextToken());
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                talSp[i] = Double.parseDouble(stx.nextToken());
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                tcpSp[i] = Double.parseDouble(stx.nextToken());
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                cthSp[i] = Double.parseDouble(stx.nextToken());
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                maxAgeSp[i] = Double.parseDouble(stx.nextToken());
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                nCT[i] = Integer.parseInt(stx.nextToken());
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                tR[i] = Integer.parseInt(stx.nextToken());
            }
            in.readLine();
            while ((s = in.readLine()) != null) {
                stx = new StringTokenizer(s, delim);
                int code = Integer.parseInt(stx.nextToken());
                double numberoftrees = Double.parseDouble(stx.nextToken());
                String no = stx.nextToken();
                int age = Integer.parseInt(stx.nextToken());
                double dbh = Double.parseDouble(stx.nextToken());
                double height = Double.parseDouble(stx.nextToken());
                double site = Double.parseDouble(stx.nextToken());
                double crbase = Double.parseDouble(stx.nextToken());
                double crwidth = Double.parseDouble(stx.nextToken());
                int out = Integer.parseInt(stx.nextToken());
                int outtype = Integer.parseInt(stx.nextToken());
                double x = Double.parseDouble(stx.nextToken());
                double y = Double.parseDouble(stx.nextToken());
                double z = Double.parseDouble(stx.nextToken());
                int zb = Integer.parseInt(stx.nextToken());
                int tzb = Integer.parseInt(stx.nextToken());
                int hb = Integer.parseInt(stx.nextToken());
                int ntimes = (int)numberoftrees;
                if (numberoftrees - (double)ntimes > 1.0) {
                    st.addtreefac(code, no, age, out, dbh, height, crbase, crwidth, site, x, y, z, zb, tzb, hb, numberoftrees);
                } else {
                    int i2 = 0;
                    while ((double)i2 < numberoftrees) {
                        st.addtree(code, no, age, out, dbh, height, crbase, crwidth, site, x, y, z, zb, tzb, hb);
                        ++i2;
                    }
                }
                if (no.compareTo("nurH") != 0 || numberoftrees != 0.0) continue;
                st.addtree(code, no, age, out, dbh, height, crbase, crwidth, site, x, y, z, zb, tzb, hb);
            }
            for (i = 0; i < st.nspecies; ++i) {
                for (int j = 0; j < nspecies; ++j) {
                    if (st.sp[i].code != codeSp[j]) continue;
                    st.sp[i].trule.targetDiameter = tdSp[j];
                    st.sp[i].trule.thinningIntensity = tISp[j];
                    st.sp[i].trule.targetDiameterLayer = tdlSp[j];
                    st.sp[i].trule.targetAgeLayer = talSp[j];
                    st.sp[i].trule.targetCrownPercent = tcpSp[j];
                    st.sp[i].trule.minCropTreeHeight = cthSp[j];
                    st.sp[i].trule.maxAge = maxAgeSp[j];
                    st.sp[i].trule.numberCropTreesWanted = nCT[j];
                    st.sp[i].trule.targetRang = tR[j];
                }
            }
        }
        catch (IOException | NumberFormatException | SpeciesNotDefinedException e) {
            LOGGER.log(Level.SEVERE, "treegross", e);
        }
    }

    public void readOldFormat3(Stand st, String fn) {
        try {
            int i;
            st.newStand();
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(fn)));
            in.readLine();
            st.addName(in.readLine());
            String s = in.readLine();
            String delim = ";";
            StringTokenizer stx = new StringTokenizer(s, delim);
            st.year = Integer.parseInt(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.addsize(Double.parseDouble(stx.nextToken()));
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            int nx = Integer.parseInt(stx.nextToken());
            in.readLine();
            for (int ii = 0; ii < nx; ++ii) {
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                st.addcornerpoint(stx.nextToken(), Double.parseDouble(stx.nextToken()), Double.parseDouble(stx.nextToken()), Double.parseDouble(stx.nextToken()));
            }
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            int rge = Integer.parseInt(stx.nextToken());
            if (rge == 1) {
                st.random.setRandomType(11);
            } else if (rge == 1) {
                st.random.setRandomType(10);
            } else {
                st.random.setRandomType(rge);
            }
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            int dd = Integer.parseInt(stx.nextToken());
            st.distanceDependent = dd == 1;
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            int ia = Integer.parseInt(stx.nextToken());
            st.ingrowthActive = ia == 1;
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.treatmentType = Integer.parseInt(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.maxHarvestVolume = Double.parseDouble(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.minHarvestVolume = Double.parseDouble(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.maxThinningVolume = Double.parseDouble(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.minThinningVolume = Double.parseDouble(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.minOutVolume = Double.parseDouble(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.maxOutVolume = Double.parseDouble(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.nHabitat = Double.parseDouble(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            int pm = Integer.parseInt(stx.nextToken());
            st.trule.protectMinorities = pm == 1;
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            int nspecies = Integer.parseInt(stx.nextToken());
            int[] codeSp = new int[nspecies];
            double[] tdSp = new double[nspecies];
            double[] tcpSp = new double[nspecies];
            double[] cthSp = new double[nspecies];
            double[] maxAgeSp = new double[nspecies];
            double[] thIntensSp = new double[nspecies];
            for (i = 0; i < nspecies; ++i) {
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                codeSp[i] = Integer.parseInt(stx.nextToken());
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                tdSp[i] = Double.parseDouble(stx.nextToken());
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                tcpSp[i] = Double.parseDouble(stx.nextToken());
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                cthSp[i] = Double.parseDouble(stx.nextToken());
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                maxAgeSp[i] = Double.parseDouble(stx.nextToken());
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                thIntensSp[i] = Double.parseDouble(stx.nextToken());
            }
            in.readLine();
            while ((s = in.readLine()) != null) {
                stx = new StringTokenizer(s, delim);
                int code = Integer.parseInt(stx.nextToken());
                double numberoftrees = Double.parseDouble(stx.nextToken());
                String no = stx.nextToken();
                int age = Integer.parseInt(stx.nextToken());
                double dbh = Double.parseDouble(stx.nextToken());
                double height = Double.parseDouble(stx.nextToken());
                double site = Double.parseDouble(stx.nextToken());
                double crbase = Double.parseDouble(stx.nextToken());
                double crwidth = Double.parseDouble(stx.nextToken());
                int out = Integer.parseInt(stx.nextToken());
                int outtype = Integer.parseInt(stx.nextToken());
                double x = Double.parseDouble(stx.nextToken());
                double y = Double.parseDouble(stx.nextToken());
                double z = Double.parseDouble(stx.nextToken());
                int zb = Integer.parseInt(stx.nextToken());
                int tzb = Integer.parseInt(stx.nextToken());
                int hb = Integer.parseInt(stx.nextToken());
                int ntimes = (int)numberoftrees;
                if (numberoftrees - (double)ntimes > 1.0) {
                    st.addtreefac(code, no, age, out, dbh, height, crbase, crwidth, site, x, y, z, zb, tzb, hb, numberoftrees);
                } else {
                    int i2 = 0;
                    while ((double)i2 < numberoftrees) {
                        st.addtree(code, no, age, out, dbh, height, crbase, crwidth, site, x, y, z, zb, tzb, hb);
                        ++i2;
                    }
                }
                if (no.compareTo("nurH") != 0 || numberoftrees != 0.0) continue;
                st.addtree(code, no, age, out, dbh, height, crbase, crwidth, site, x, y, z, zb, tzb, hb);
            }
            for (i = 0; i < st.nspecies; ++i) {
                for (int j = 0; j < nspecies; ++j) {
                    if (st.sp[i].code != codeSp[j]) continue;
                    st.sp[i].trule.targetDiameter = tdSp[j];
                    st.sp[i].trule.targetCrownPercent = tcpSp[j];
                    st.sp[i].trule.minCropTreeHeight = cthSp[j];
                    st.sp[i].trule.maxAge = maxAgeSp[j];
                    st.sp[i].trule.thinningIntensity = thIntensSp[j];
                }
            }
        }
        catch (IOException | NumberFormatException | SpeciesNotDefinedException e) {
            LOGGER.log(Level.SEVERE, "treegross", e);
        }
    }

    public void readOldFormat2(Stand st, String fn) {
        try {
            int i;
            st.ntrees = 0;
            st.nspecies = 0;
            st.ncpnt = 0;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(fn)));
            in.readLine();
            st.addName(in.readLine());
            String s = in.readLine();
            String delim = ";";
            StringTokenizer stx = new StringTokenizer(s, delim);
            st.year = Integer.parseInt(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.addsize(Double.parseDouble(stx.nextToken()));
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            int nx = Integer.parseInt(stx.nextToken());
            in.readLine();
            for (int ii = 0; ii < nx; ++ii) {
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                st.addcornerpoint(stx.nextToken(), Double.parseDouble(stx.nextToken()), Double.parseDouble(stx.nextToken()), Double.parseDouble(stx.nextToken()));
            }
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            int rge = Integer.parseInt(stx.nextToken());
            if (rge == 1) {
                st.random.setRandomType(11);
            } else if (rge == 1) {
                st.random.setRandomType(10);
            } else {
                st.random.setRandomType(rge);
            }
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            int dd = Integer.parseInt(stx.nextToken());
            st.distanceDependent = dd == 1;
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            int ia = Integer.parseInt(stx.nextToken());
            st.ingrowthActive = ia == 1;
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.treatmentType = Integer.parseInt(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.maxHarvestVolume = Double.parseDouble(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.minHarvestVolume = Double.parseDouble(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.maxThinningVolume = Double.parseDouble(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.minThinningVolume = Double.parseDouble(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.minOutVolume = Double.parseDouble(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.maxOutVolume = Double.parseDouble(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            for (int i2 = 0; i2 < st.nspecies; ++i2) {
                st.sp[i2].trule.thinningIntensity = Double.parseDouble(stx.nextToken());
            }
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.trule.nHabitat = Double.parseDouble(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            int pm = Integer.parseInt(stx.nextToken());
            st.trule.protectMinorities = pm == 1;
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            int nspecies = Integer.parseInt(stx.nextToken());
            int[] codeSp = new int[nspecies];
            double[] tdSp = new double[nspecies];
            double[] tcpSp = new double[nspecies];
            double[] cthSp = new double[nspecies];
            double[] maxAgeSp = new double[nspecies];
            for (i = 0; i < nspecies; ++i) {
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                codeSp[i] = Integer.parseInt(stx.nextToken());
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                tdSp[i] = Double.parseDouble(stx.nextToken());
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                tcpSp[i] = Double.parseDouble(stx.nextToken());
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                cthSp[i] = Double.parseDouble(stx.nextToken());
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                maxAgeSp[i] = Double.parseDouble(stx.nextToken());
            }
            in.readLine();
            while ((s = in.readLine()) != null) {
                stx = new StringTokenizer(s, delim);
                int code = Integer.parseInt(stx.nextToken());
                double numberoftrees = Double.parseDouble(stx.nextToken());
                String no = stx.nextToken();
                int age = Integer.parseInt(stx.nextToken());
                double dbh = Double.parseDouble(stx.nextToken());
                double height = Double.parseDouble(stx.nextToken());
                double site = Double.parseDouble(stx.nextToken());
                double crbase = Double.parseDouble(stx.nextToken());
                double crwidth = Double.parseDouble(stx.nextToken());
                int out = Integer.parseInt(stx.nextToken());
                int outtype = Integer.parseInt(stx.nextToken());
                double x = Double.parseDouble(stx.nextToken());
                double y = Double.parseDouble(stx.nextToken());
                double z = Double.parseDouble(stx.nextToken());
                int zb = Integer.parseInt(stx.nextToken());
                int tzb = Integer.parseInt(stx.nextToken());
                int hb = Integer.parseInt(stx.nextToken());
                int ntimes = (int)numberoftrees;
                if (numberoftrees - (double)ntimes > 1.0) {
                    st.addtreefac(code, no, age, out, dbh, height, crbase, crwidth, site, x, y, z, zb, tzb, hb, numberoftrees);
                } else {
                    int i3 = 0;
                    while ((double)i3 < numberoftrees) {
                        st.addtree(code, no, age, out, dbh, height, crbase, crwidth, site, x, y, z, zb, tzb, hb);
                        ++i3;
                    }
                }
                if (no.compareTo("nurH") != 0 || numberoftrees != 0.0) continue;
                st.addtree(code, no, age, out, dbh, height, crbase, crwidth, site, x, y, z, zb, tzb, hb);
            }
            for (i = 0; i < st.nspecies; ++i) {
                for (int j = 0; j < nspecies; ++j) {
                    if (st.sp[i].code != codeSp[j]) continue;
                    st.sp[i].trule.targetDiameter = tdSp[j];
                    st.sp[i].trule.targetCrownPercent = tcpSp[j];
                    st.sp[i].trule.minCropTreeHeight = cthSp[j];
                    st.sp[i].trule.maxAge = maxAgeSp[j];
                }
            }
        }
        catch (IOException | NumberFormatException | SpeciesNotDefinedException e) {
            LOGGER.log(Level.SEVERE, "treegross", e);
        }
    }

    public void readOldFormat1(Stand st, String fn) {
        try {
            st.ntrees = 0;
            st.nspecies = 0;
            st.ncpnt = 0;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(fn)));
            in.readLine();
            st.addName(in.readLine());
            String s = in.readLine();
            String delim = ";";
            StringTokenizer stx = new StringTokenizer(s, delim);
            st.year = Integer.parseInt(stx.nextToken());
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            st.addsize(Double.parseDouble(stx.nextToken()));
            s = in.readLine();
            stx = new StringTokenizer(s, delim);
            int nx = Integer.parseInt(stx.nextToken());
            in.readLine();
            for (int ii = 0; ii < nx; ++ii) {
                s = in.readLine();
                stx = new StringTokenizer(s, delim);
                st.addcornerpoint(stx.nextToken(), Double.parseDouble(stx.nextToken()), Double.parseDouble(stx.nextToken()), Double.parseDouble(stx.nextToken()));
            }
            in.readLine();
            while ((s = in.readLine()) != null) {
                stx = new StringTokenizer(s, delim);
                int code = Integer.parseInt(stx.nextToken());
                double numberoftrees = Double.parseDouble(stx.nextToken());
                String no = stx.nextToken();
                int age = Integer.parseInt(stx.nextToken());
                double dbh = Double.parseDouble(stx.nextToken());
                double height = Double.parseDouble(stx.nextToken());
                double site = Double.parseDouble(stx.nextToken());
                double crbase = Double.parseDouble(stx.nextToken());
                double crwidth = Double.parseDouble(stx.nextToken());
                int out = Integer.parseInt(stx.nextToken());
                int outtype = Integer.parseInt(stx.nextToken());
                double x = Double.parseDouble(stx.nextToken());
                double y = Double.parseDouble(stx.nextToken());
                double z = Double.parseDouble(stx.nextToken());
                int zb = Integer.parseInt(stx.nextToken());
                int ntimes = (int)numberoftrees;
                if (out < 0) {
                    outtype = 0;
                }
                if (numberoftrees - (double)ntimes > 1.0) {
                    st.addtreefac(code, no, age, out, dbh, height, crbase, crwidth, site, x, y, z, zb, 0, 0, numberoftrees);
                    st.tr[st.ntrees - 1].outtype = outtype;
                } else {
                    int i = 0;
                    while ((double)i < numberoftrees) {
                        st.addtree(code, no, age, out, dbh, height, crbase, crwidth, site, x, y, z, zb, 0, 0);
                        st.tr[st.ntrees - 1].outtype = outtype;
                        ++i;
                    }
                }
                if (no.compareTo("nurH") != 0 || numberoftrees != 0.0) continue;
                st.addtree(code, no, age, out, dbh, height, crbase, crwidth, site, x, y, z, zb, 0, 0);
            }
        }
        catch (IOException | NumberFormatException | SpeciesNotDefinedException e) {
            LOGGER.log(Level.SEVERE, "treegross", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTreeTable(Stand st) {
        try (PrintWriter out = null;){
            int i;
            NumberFormat f = NumberFormat.getInstance(new Locale("en", "US"));
            f.setMaximumFractionDigits(2);
            f.setMinimumFractionDigits(2);
            out = new PrintWriter(new OutputStreamWriter(new FileOutputStream("baumtabelle.txt")));
            for (i = 0; i < st.ntrees; ++i) {
                st.tr[i].updateCrown();
            }
            for (i = 0; i < st.ntrees; ++i) {
                st.tr[i].updateCompetition();
            }
            for (i = 1; i < st.ntrees; ++i) {
                out.println(st.standname + "," + f.format(st.size) + "," + st.year + "," + st.tr[i].no + "," + st.tr[i].code + "," + st.tr[i].age + "," + f.format(st.tr[i].d) + "," + f.format(st.tr[i].h) + "," + f.format(st.tr[i].cb) + "," + f.format(st.tr[i].cw) + "," + f.format(st.tr[i].cbLightCrown) + "," + f.format(st.tr[i].cwLightCrown) + "," + f.format(st.tr[i].c66) + "," + f.format(st.tr[i].c66c) + "," + f.format(st.tr[i].x) + "," + f.format(st.tr[i].y));
            }
        }
    }
}

