/*
 * Decompiled with CFR 0.152.
 */
package treegross.base;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.nfunk.jep.JEP;
import treegross.base.Species;
import treegross.base.Tree;
import treegross.functions.InvLogit;
import treegross.functions.TGClassFunction;
import treegross.functions.TGFunction;
import treegross.random.RandomNumber;

public class FunctionInterpreter {
    private JEP jep;

    public String getLastError() {
        if (this.jep != null) {
            return this.jep.getErrorInfo();
        }
        return "JEP not used";
    }

    public double getValueForTree(Tree t, TGFunction func) {
        if (func.getType() == 1) {
            TGClassFunction cf = (TGClassFunction)func;
            return cf.getFunctionClass().getValueForTree(t, func.getFunctionText());
        }
        String function = func.getFunctionText();
        return this.getValueForTree(t, function);
    }

    public double getValueForTree(Tree t, String func) {
        String function = func;
        this.jep = new JEP();
        if (function.contains("t.d")) {
            this.jep.addVariable("t.d", t.d);
        }
        if (function.contains("t.h")) {
            this.jep.addVariable("t.h", t.h);
        }
        if (function.contains("t.age")) {
            this.jep.addVariable("t.age", t.age);
        }
        if (function.contains("t.cb")) {
            this.jep.addVariable("t.cb", t.cb);
        }
        if (function.contains("t.cw")) {
            this.jep.addVariable("t.cw", t.cw);
        }
        if (function.contains("t.c66c")) {
            this.jep.addVariable("t.c66c", t.c66c);
        }
        if (function.contains("t.c66")) {
            this.jep.addVariable("t.c66", t.c66);
        }
        if (function.contains("t.c66cxy")) {
            this.jep.addVariable("t.c66cxy", t.c66cxy);
        }
        if (function.contains("t.c66xy")) {
            this.jep.addVariable("t.c66xy", t.c66xy);
        }
        if (function.contains("t.out")) {
            this.jep.addVariable("t.out", t.out);
        }
        if (function.contains("t.si")) {
            if (t.si > 110.0) {
                if (t.st != null) {
                    Logger.getLogger(FunctionInterpreter.class.getName()).log(Level.WARNING, "Tree {0} @ stand {1}: Site index > {2}m! Using 40m.", new Object[]{t.no, t.st.standname, 110.0});
                } else {
                    Logger.getLogger(FunctionInterpreter.class.getName()).log(Level.WARNING, "Tree {0}: Site index > {1}m! Using 40m.", new Object[]{t.no, 110.0});
                }
                this.jep.addVariable("t.si", 40.0);
            } else {
                this.jep.addVariable("t.si", t.si);
            }
        }
        if (function.contains("t.ihpot")) {
            this.jep.addVariable("t.ihpot", t.ihpot);
        }
        if (function.contains("t.hinc")) {
            this.jep.addVariable("t.hinc", t.hinc);
        }
        if (function.contains("sp.hg")) {
            this.jep.addVariable("sp.hg", t.sp.hg);
        }
        if (function.contains("sp.dg")) {
            this.jep.addVariable("sp.dg", t.sp.dg);
        }
        if (function.contains("sp.h100")) {
            this.jep.addVariable("sp.h100", t.sp.h100);
        }
        if (function.contains("sp.year")) {
            this.jep.addVariable("sp.year", t.st.year);
        }
        if (function.contains("sp.BHD_STD")) {
            this.jep.addVariable("sp.BHD_STD", this.getBHD_STD(t));
        }
        if (function.contains("sp.Cw_dg")) {
            this.jep.addVariable("sp.Cw_dg", this.getCw_dg(t));
        }
        if (function.contains("sp.gha")) {
            this.jep.addVariable("sp.gha", t.sp.gha);
        }
        if (function.contains("st.gha")) {
            this.jep.addVariable("st.gha", t.st.bha);
        }
        this.jep.addStandardFunctions();
        this.jep.addFunction("inv.logit", new InvLogit());
        this.jep.parseExpression(function);
        return this.jep.getValue();
    }

    public double getValueForSpecies(Species sp, TGFunction func, RandomNumber rn) {
        if (func.getType() == 1) {
            TGClassFunction cf = (TGClassFunction)func;
            return cf.getFunctionClass().getValueForSpecies(sp, func.getFunctionText());
        }
        String function = func.getFunctionText();
        this.jep = new JEP();
        if (function.contains("sp.dg")) {
            this.jep.addVariable("sp.dg", sp.dg);
        }
        if (function.contains("sp.h100")) {
            this.jep.addVariable("sp.h100", sp.h100);
        }
        if (function.contains("dmax")) {
            this.jep.addVariable("dmax", sp.dmax);
        }
        if (function.contains("random")) {
            this.jep.addVariable("random", rn.nextUniform());
        }
        this.jep.addStandardFunctions();
        this.jep.parseExpression(function);
        return this.jep.getValue();
    }

    private double getBHD_STD(Tree t) {
        double sError = 0.0;
        double dm = 0.0;
        int ndg = 0;
        for (int i = t.st.ntrees - 1; i >= 0; --i) {
            if (t.code != t.st.tr[i].code || t.st.tr[i].out >= 0) continue;
            dm += t.st.tr[i].d;
            ++ndg;
        }
        if (ndg > 0) {
            dm /= (double)ndg;
            double sum = 0.0;
            for (int i = t.st.ntrees - 1; i >= 0; --i) {
                if (t.code != t.st.tr[i].code || t.st.tr[i].out >= 0) continue;
                double dmd = t.st.tr[i].d - dm;
                sum += dmd * dmd;
            }
            sError = ndg > 1 ? Math.sqrt(sum / (double)(ndg - 1)) / Math.sqrt(ndg) : 1.0;
        }
        return sError;
    }

    private double getCw_dg(Tree t) {
        Tree atree = new Tree();
        atree.sp = t.sp;
        atree.code = t.code;
        atree.d = t.sp.dg;
        atree.h = t.sp.hg;
        atree.cb = atree.calculateCb();
        atree.cw = atree.calculateCw();
        return atree.cw;
    }
}

