/*
 * Decompiled with CFR 0.152.
 */
package treegross.base;

import treegross.base.FunctionInterpreter;
import treegross.base.Species;
import treegross.base.Stand;
import treegross.base.TooMuchTreesException;

public class GenDistribution {
    public void noDist(Stand st, int art, int alter, double dg, double hg, double gfl, boolean correct) throws Exception {
        double gsum = 0.0;
        double dgen = dg;
        double g = Math.PI * (dgen * 0.005) * (dgen * 0.005);
        boolean tooMuchTrees = false;
        do {
            gsum += g;
            Integer nox = st.ntrees + 2;
            String nr = nox.toString();
            if (!st.addtree(art, nr, alter, -1, dgen, hg, 0.0, 0.0, -9.0, 0.0, 0.0, 0.0, 0, 0, 0)) {
                tooMuchTrees = true;
                break;
            }
            if (!correct) continue;
            this.checkGAndCorrectFactor(gfl, gsum, st);
        } while (gsum < gfl);
        if (tooMuchTrees) {
            throw new TooMuchTreesException(st);
        }
    }

    public void weibull(Stand st, int art, int alter, double dg, double hg, double dmax, double gfl, boolean correct) throws Exception {
        Species spx = new Species();
        spx.spDef = st.getSDM().getByCode(art);
        if (spx.spDef == null) {
            System.err.println("species definition NULL for species " + art);
            return;
        }
        if (spx.spDef.diameterDistributionXML == null) {
            System.err.println("spDef.diameterDistributionXML NULL for species " + art);
            return;
        }
        spx.dg = dg;
        spx.dmax = dmax > dg ? dmax : dg * 1.2;
        double gsum = 0.0;
        boolean tooMuchTrees = false;
        do {
            FunctionInterpreter fi;
            double dgen;
            if ((dgen = (fi = new FunctionInterpreter()).getValueForSpecies(spx, spx.spDef.diameterDistributionXML, st.random)) < 7.01) {
                dgen = 7.01;
            }
            gsum += Math.PI * (dgen * 0.005) * (dgen * 0.005);
            if (st.addtree(art, Integer.toString(st.ntrees + 2), alter, -1, dgen, 0.0, 0.0, 0.0, -9.0, 0.0, 0.0, 0.0, 0, 0, 0)) continue;
            tooMuchTrees = true;
            break;
        } while (gsum < gfl);
        if (tooMuchTrees) {
            throw new TooMuchTreesException(st);
        }
        if (correct) {
            this.checkGAndCorrectFactor(gfl, gsum, st);
        }
    }

    public void weibullEven(Stand st, int art, int alter, double dg, double hg, double dmax, double gfl, boolean correct) throws Exception {
        double gsum = 0.0;
        String nr = "";
        int ngen = 0;
        boolean tooMuchTrees = false;
        if (dg - (dmax - dg) > 7.0) {
            int anzahl;
            nr = "";
            Species spx = new Species();
            spx.spDef = st.getSDM().getByCode(art);
            spx.dg = dg;
            spx.dmax = dmax;
            gsum = 0.0;
            int ncycle = 0;
            double g = Math.PI * (dg * 0.005 * (dg * 0.005));
            block0: do {
                ++ncycle;
                anzahl = (int)((gfl - gsum) * 0.8 / g);
                if (anzahl <= 0 || st.ntrees + anzahl >= st.maxStandTrees) continue;
                for (int i = 0; i < anzahl; ++i) {
                    FunctionInterpreter fi = new FunctionInterpreter();
                    double dgen = fi.getValueForSpecies(spx, spx.spDef.diameterDistributionXML, st.random);
                    gsum += Math.PI * (dgen * 0.005) * (dgen * 0.005);
                    Integer nox = st.ntrees + 2;
                    nr = nox.toString();
                    if (!st.addtree(art, nr, alter, -1, dgen, 0.0, 0.0, 0.0, -9.0, 0.0, 0.0, 0.0, 0, 0, 0)) {
                        tooMuchTrees = true;
                        continue block0;
                    }
                    if (correct) {
                        this.checkGAndCorrectFactor(gfl, gsum, st);
                    }
                    ++ngen;
                }
            } while (Math.abs(gfl - gsum) > 0.05 && ncycle < 20 && anzahl > 0 && !tooMuchTrees);
        } else {
            do {
                double dgen;
                if (!((dgen = dg + (dmax - dg) * st.random.nextNormal(3.0)) >= 1.0)) continue;
                gsum += Math.PI * (dgen * 0.005) * (dgen * 0.005);
                Integer nox = st.ntrees + 2;
                nr = nox.toString();
                if (!st.addtree(art, nr, alter, -1, dgen, 0.0, 0.0, 0.0, -9.0, 0.0, 0.0, 0.0, 0, 0, 0)) {
                    tooMuchTrees = true;
                    break;
                }
                if (correct) {
                    this.checkGAndCorrectFactor(gfl, gsum, st);
                }
                ++ngen;
            } while (gfl > gsum && st.ntrees < st.maxStandTrees);
        }
        if (ngen == 0 && !st.addtree(art, nr, alter, -1, dg, hg, 0.0, 0.0, -9.0, 0.0, 0.0, 0.0, 0, 0, 0)) {
            tooMuchTrees = true;
        }
        if (tooMuchTrees) {
            throw new TooMuchTreesException(st);
        }
    }

    private void checkGAndCorrectFactor(double gsoll, double gist, Stand st) {
        if (gist > gsoll && st.tr[st.ntrees - 1].d > 0.0) {
            double gT = Math.PI * (st.tr[st.ntrees - 1].d * 0.005 * (st.tr[st.ntrees - 1].d * 0.005));
            st.tr[st.ntrees - 1].fac = 1.0 - (gist - gsoll) / gT;
            if (st.tr[st.ntrees - 1].fac < 1.0E-8) {
                st.tr[st.ntrees - 1].fac = 1.0E-8;
            }
        }
    }
}

