/*
 * Decompiled with CFR 0.152.
 */
package treegross.base;

import treegross.base.FunctionInterpreter;
import treegross.base.HeightCurve;
import treegross.base.SpeciesDef;
import treegross.base.Stand;
import treegross.base.TreatmentRuleSpecies;
import treegross.base.Tree;

public class Species
implements Cloneable {
    public int code;
    public double h100age;
    public double dg;
    public double hg;
    public double d100;
    public double h100;
    public double hbon;
    public double dgout;
    public double vol;
    public double gha;
    public double nha;
    public double vhaout;
    public double ghaout;
    public double nhaout;
    public double percBA;
    public double percCSA;
    public double size;
    public SpeciesDef spDef = new SpeciesDef();
    public TreatmentRuleSpecies trule = new TreatmentRuleSpecies();
    public double totalPrice;
    public double[] price;
    public double vjkl1;
    public double vjkl2;
    public double vjkl3;
    public String heightcurveUsed = "";
    public double heightcurveUsedP0;
    public double heightcurveUsedP1;
    public double heightcurveUsedP2;
    public double volumeOfDeadwood;
    public double dmax;

    public Species clone() {
        Species clone = new Species();
        clone.code = this.code;
        clone.d100 = this.d100;
        clone.dg = this.dg;
        clone.dgout = this.dgout;
        clone.gha = this.gha;
        clone.ghaout = this.ghaout;
        clone.h100 = this.h100;
        clone.h100age = this.h100age;
        clone.hbon = this.hbon;
        clone.heightcurveUsed = this.heightcurveUsed;
        clone.heightcurveUsedP0 = this.heightcurveUsedP0;
        clone.heightcurveUsedP1 = this.heightcurveUsedP1;
        clone.heightcurveUsedP2 = this.heightcurveUsedP2;
        clone.hg = this.hg;
        clone.nha = this.nha;
        clone.nhaout = this.nhaout;
        clone.percBA = this.percBA;
        clone.percCSA = this.percCSA;
        if (this.price != null) {
            clone.price = (double[])this.price.clone();
        }
        clone.size = this.size;
        clone.spDef = this.spDef.clone();
        clone.totalPrice = this.totalPrice;
        clone.trule = this.trule.clone();
        clone.vhaout = this.vhaout;
        clone.vjkl1 = this.vjkl1;
        clone.vjkl2 = this.vjkl2;
        clone.vjkl3 = this.vjkl3;
        clone.vol = this.vol;
        return clone;
    }

    void setZero() {
        this.h100age = 0.0;
        this.dg = 0.0;
        this.hg = 0.0;
        this.d100 = 0.0;
        this.h100 = 0.0;
        this.dgout = 0.0;
        this.vol = 0.0;
        this.gha = 0.0;
        this.nha = 0.0;
        this.vhaout = 0.0;
        this.ghaout = 0.0;
        this.nhaout = 0.0;
        this.percBA = 0.0;
        this.percCSA = 0.0;
        this.volumeOfDeadwood = 0.0;
    }

    void updateSpecies(Stand st) {
        int j;
        double hgmerk;
        FunctionInterpreter fi;
        Tree tree;
        double dgmerk;
        this.setZero();
        double ghaStand = 0.0;
        for (int i = 0; i < st.ntrees; ++i) {
            if (st.tr[i].code == this.code) {
                if (st.tr[i].d >= 7.0) {
                    if (st.tr[i].out < 1) {
                        this.nha += st.tr[i].fac;
                        this.gha += st.tr[i].fac * Math.PI * (st.tr[i].d / 200.0) * (st.tr[i].d / 200.0);
                        this.vol += st.tr[i].fac * st.tr[i].v;
                    } else if (st.tr[i].out == st.year) {
                        this.nhaout += st.tr[i].fac;
                        this.ghaout += st.tr[i].fac * Math.PI * (st.tr[i].d / 200.0) * (st.tr[i].d / 200.0);
                        this.vhaout += st.tr[i].fac * st.tr[i].v;
                    }
                }
                if (st.tr[i].out > 0) {
                    this.volumeOfDeadwood += st.tr[i].fac * st.tr[i].volumeDeadwood;
                }
            }
            if (!(st.tr[i].d >= 7.0) || st.tr[i].out >= 0) continue;
            ghaStand += st.tr[i].fac * Math.PI * (st.tr[i].d / 200.0) * (st.tr[i].d / 200.0);
        }
        this.volumeOfDeadwood /= st.size;
        this.nha /= st.size;
        this.gha /= st.size;
        this.vol /= st.size;
        st.bha = ghaStand /= st.size;
        this.nhaout /= st.size;
        this.ghaout /= st.size;
        this.vhaout /= st.size;
        if (this.nha > 0.0) {
            this.dg = 200.0 * Math.sqrt(this.gha / (Math.PI * this.nha));
        }
        if (this.nhaout > 0.0) {
            this.dgout = 200.0 * Math.sqrt(this.ghaout / (Math.PI * this.nhaout));
        }
        double siH100 = 0.0;
        double nsiH100 = 0.0;
        double n100 = st.size * 100.0 * this.gha / ghaStand;
        if ((n100 = (double)Math.round(n100)) <= 0.0) {
            n100 = 1.0;
        }
        if (this.nha > 0.0 && n100 > 0.0) {
            double jj = 0.0;
            for (int k = 0; jj < n100 && k < st.ntrees; ++k) {
                if (!(st.tr[k].d >= 7.0) || st.tr[k].code != this.code || st.tr[k].out >= 1) continue;
                this.d100 += st.tr[k].fac * Math.PI * (st.tr[k].d / 200.0) * (st.tr[k].d / 200.0);
                this.h100age += st.tr[k].fac * (double)st.tr[k].age;
                if (st.tr[k].si > 0.0) {
                    siH100 += st.tr[k].si * st.tr[k].fac;
                    nsiH100 += st.tr[k].fac;
                }
                jj += st.tr[k].fac;
            }
            this.d100 = 200.0 * Math.sqrt(this.d100 / (Math.PI * jj));
            this.h100age /= jj;
            siH100 = nsiH100 > 0.0 ? (siH100 /= nsiH100) : 0.0;
        }
        boolean pettersonFalse = false;
        int ndh = 0;
        for (int j2 = 0; j2 < st.ntrees; ++j2) {
            if (!(st.tr[j2].d >= 7.0) || st.tr[j2].code != this.code || !(st.tr[j2].h > 1.3) || st.tr[j2].out >= 1 && st.tr[j2].out != st.year) continue;
            ++ndh;
        }
        int missingheights = st.getMissingHeight(0);
        if (ndh > 5) {
            int j3;
            int k = ndh / 1000;
            ++k;
            ndh = 0;
            for (int j4 = 0; j4 < st.ntrees; j4 += k) {
                if (!(st.tr[j4].d >= 7.0) || st.tr[j4].code != this.code || !(st.tr[j4].h > 1.3) || st.tr[j4].out >= 1 && st.tr[j4].out != st.year) continue;
                ++ndh;
            }
            HeightCurve m = new HeightCurve();
            m.heightcurve();
            for (j3 = 0; j3 < st.ntrees; j3 += k) {
                if (!(st.tr[j3].d >= 7.0) || st.tr[j3].code != this.code || !(st.tr[j3].h > 1.3) || st.tr[j3].out >= 1 && st.tr[j3].out != st.year) continue;
                m.adddh(this.spDef.heightCurve, ndh, st.tr[j3].d, st.tr[j3].h);
            }
            m.start();
            if (this.dg > 0.0) {
                this.hg = m.hwert(this.spDef.heightCurve, this.dg);
            }
            if (this.d100 > 0.0) {
                this.h100 = m.hwert(this.spDef.heightCurve, this.d100);
            }
            this.heightcurveUsed = m.getHeightCurveName(this.spDef.heightCurve);
            this.heightcurveUsedP0 = m.getb0();
            this.heightcurveUsedP1 = m.getb1();
            this.heightcurveUsedP2 = m.getb2();
            if (m.hwert(this.spDef.heightCurve, 80.0) > 80.0) {
                pettersonFalse = true;
            }
            if (missingheights > 0) {
                for (j3 = 0; j3 < st.ntrees; ++j3) {
                    if (!(st.tr[j3].d >= 7.0) || st.tr[j3].code != this.code || !(st.tr[j3].h < 1.3)) continue;
                    st.tr[j3].h = m.hwert(this.spDef.heightCurve, st.tr[j3].d);
                }
            }
        }
        double dk = 0.0;
        double hk = 0.0;
        if (ndh > 0 && ndh <= 5 || pettersonFalse) {
            for (int j5 = 0; j5 < st.ntrees; ++j5) {
                if (!(st.tr[j5].d >= 7.0) || st.tr[j5].code != this.code || !(st.tr[j5].h > 1.3) || st.tr[j5].out >= 1 && st.tr[j5].out != st.year || !(st.tr[j5].d > dk)) continue;
                dk = st.tr[j5].d;
                hk = st.tr[j5].h;
            }
            dgmerk = this.dg;
            tree = new Tree();
            tree.d = this.d100;
            tree.sp = this;
            tree.sp.dg = dk;
            tree.sp.hg = hk;
            fi = new FunctionInterpreter();
            this.h100 = fi.getValueForTree(tree, tree.sp.spDef.uniformHeightCurveXML);
            tree.d = this.dg;
            hgmerk = fi.getValueForTree(tree, tree.sp.spDef.uniformHeightCurveXML);
            this.heightcurveUsed = "Einheitsh\u00f6henkurve";
            this.heightcurveUsedP0 = dk;
            this.heightcurveUsedP1 = hk;
            if (missingheights > 0) {
                for (j = 0; j < st.ntrees; ++j) {
                    if (!(st.tr[j].d >= 7.0) || st.tr[j].code != this.code || !(st.tr[j].h < 1.3)) continue;
                    tree.d = st.tr[j].d;
                    st.tr[j].h = fi.getValueForTree(tree, tree.sp.spDef.uniformHeightCurveXML);
                }
            }
            this.dg = dgmerk;
            this.hg = hgmerk;
        }
        if (ndh <= 0) {
            for (int j6 = 0; j6 < st.ntrees; ++j6) {
                if (!(st.tr[j6].d >= 7.0) || !(st.tr[j6].h > 1.3) || st.tr[j6].out >= 1 || !(st.tr[j6].d > dk)) continue;
                dk = st.tr[j6].d;
                hk = st.tr[j6].h;
            }
            this.heightcurveUsed = "Einheitsh\u00f6henkurve: ";
            this.heightcurveUsedP0 = dk;
            this.heightcurveUsedP1 = hk;
            dgmerk = this.dg;
            hgmerk = this.hg;
            tree = new Tree();
            tree.d = this.d100;
            tree.sp = this;
            tree.sp.dg = dk;
            tree.sp.hg = hk;
            fi = new FunctionInterpreter();
            if (dk > 7.0) {
                this.h100 = fi.getValueForTree(tree, tree.sp.spDef.uniformHeightCurveXML);
            }
            if (missingheights > 0) {
                for (j = 0; j < st.ntrees; ++j) {
                    if (!(st.tr[j].d >= 7.0) || st.tr[j].code != this.code || !(st.tr[j].h < 1.3)) continue;
                    tree.d = st.tr[j].d;
                    st.tr[j].h = fi.getValueForTree(tree, tree.sp.spDef.uniformHeightCurveXML);
                }
            }
            this.dg = dgmerk;
            this.hg = hgmerk;
        }
        if (siH100 > 0.0) {
            this.hbon = siH100;
        } else {
            Tree atree = new Tree();
            atree.d = 30.0;
            atree.age = (int)this.h100age;
            atree.h = this.h100;
            atree.code = this.code;
            atree.sp = this;
            if (this.hbon <= 0.0) {
                this.hbon = atree.calculateSiteIndex();
            }
        }
    }

    public void loadTrRuleDefault() {
        TreatmentRuleSpecies tr = new TreatmentRuleSpecies();
        this.trule = tr.loadTreatmentRule(1000.0, this.spDef.targetDiameter, this.spDef.heightOfThinningStart);
    }

    public double getTotalPrice() {
        this.totalPrice = 0.0;
        for (int i = 0; i < this.price.length; ++i) {
            if (this.price[i] == -1.0) continue;
            this.totalPrice += this.price[i];
        }
        return this.totalPrice;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("species ").append(this.code).append(" ageh100:").append(this.h100age).append(" dg:").append(this.dg).append(" hg:").append(this.hg).append(" d100:").append(this.d100).append(" G:").append(this.gha);
        return sb.toString();
    }
}

