/*
 * Decompiled with CFR 0.152.
 */
package treegross.base;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import treegross.base.PlugInIngrowth;
import treegross.base.SpeciesDef;
import treegross.base.Stand;
import treegross.functions.TGClassFunction;
import treegross.functions.TGFunction;
import treegross.functions.TGTextFunction;

public class SpeciesDefMap {
    private HashMap<Integer, SpeciesDef> spcdef = null;
    private URL actualurl = null;
    private boolean loaded = false;
    private final String stdModel = "ForestSimulatorNWGermany6";
    private static final Logger LOGGER = Logger.getLogger(SpeciesDefMap.class.getName());

    public String getDefaultModelName() {
        return "ForestSimulatorNWGermany6";
    }

    public void reload() {
        if (this.loaded && this.actualurl != null) {
            this.readFromURL(this.actualurl);
        }
    }

    public void readInternal(String name) {
        URL url = name != null ? this.getClass().getResource("/treegross/model/" + name + ".xml") : this.getClass().getResource("/treegross/model/ForestSimulatorNWGermany6.xml");
        this.readFromURL(url);
    }

    public void readFromPath(String path) {
        try {
            URL url = new File(path).toURI().toURL();
            this.readFromURL(url);
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.SEVERE, "reading xml file: ", e);
        }
    }

    public void readFromURL(URL url) {
        try {
            this.readXML(url);
            this.actualurl = url;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "reading xml file: ", e);
        }
    }

    private void readXML(URL url) throws IOException {
        URLConnection urlcon = url.openConnection();
        this.actualurl = url;
        this.readXMLStream(urlcon.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readXMLStream(InputStream imps) {
        this.loaded = false;
        this.spcdef = new HashMap();
        try {
            Document d = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(imps);
            NodeList sDefs = d.getElementsByTagName("SpeciesDefinition");
            int length = sDefs.getLength();
            block11: for (int i = 0; i < length; ++i) {
                Node n = sDefs.item(i);
                NodeList modelNodes = n.getChildNodes();
                for (int j = 0; j < modelNodes.getLength(); ++j) {
                    Node m = modelNodes.item(j);
                    if (m.getNodeType() != 1) continue;
                    String tc = m.getTextContent();
                    String nn = m.getNodeName().toLowerCase();
                    if (!nn.equals("code") || tc == null || tc.length() <= 0) continue;
                    int code = Integer.parseInt(tc.trim());
                    this.addSpeciesDef(code, sDefs);
                    continue block11;
                }
            }
            this.loaded = true;
        }
        catch (IOException | NumberFormatException | ParserConfigurationException | SAXException ex) {
            LOGGER.log(Level.SEVERE, "Parsing species definition failed!", ex);
        }
        finally {
            if (imps != null) {
                try {
                    imps.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, "treegross", ex);
                }
            }
        }
    }

    private void addSpeciesDef(int code, NodeList specDefNodes) {
        if (this.spcdef.containsKey(code)) {
            return;
        }
        boolean found = false;
        for (int i = 0; i < specDefNodes.getLength(); ++i) {
            Node m;
            Node n = specDefNodes.item(i);
            NodeList modelNodes = n.getChildNodes();
            for (int j = 0; j < modelNodes.getLength(); ++j) {
                int nCode;
                m = modelNodes.item(j);
                if (m.getNodeType() != 1 || !"code".equalsIgnoreCase(m.getNodeName()) || code != (nCode = Integer.parseInt(m.getTextContent()))) continue;
                found = true;
                break;
            }
            if (!found) continue;
            SpeciesDef sd = new SpeciesDef();
            sd.code = code;
            int hlc = -1;
            block84: for (int j = 0; j < modelNodes.getLength(); ++j) {
                m = modelNodes.item(j);
                if (m.getNodeType() != 1) continue;
                String tc = m.getTextContent();
                String nn = m.getNodeName().toLowerCase();
                if (tc == null || tc.length() <= 0) continue;
                tc = tc.trim();
                switch (nn) {
                    case "handledlikecode": {
                        sd.handledLikeCode = hlc = Integer.parseInt(tc);
                        continue block84;
                    }
                    case "shortname": {
                        sd.shortName = tc;
                        continue block84;
                    }
                    case "longname": {
                        sd.longName = tc;
                        continue block84;
                    }
                    case "latinname": {
                        sd.latinName = tc;
                        continue block84;
                    }
                    case "internalcode": {
                        sd.internalCode = Integer.parseInt(tc);
                        continue block84;
                    }
                    case "codegroup": {
                        sd.codeGroup = Integer.parseInt(tc);
                        continue block84;
                    }
                    case "heightcurve": {
                        sd.heightCurve = Integer.parseInt(tc);
                        continue block84;
                    }
                    case "crowntype": {
                        sd.crownType = Integer.parseInt(tc);
                        continue block84;
                    }
                    case "heightincrementerror": {
                        sd.heightIncrementError = Double.parseDouble(tc);
                        continue block84;
                    }
                    case "diameterincrementerror": {
                        sd.diameterIncrementError = Double.parseDouble(tc);
                        continue block84;
                    }
                    case "maximumage": {
                        sd.maximumAge = Integer.parseInt(tc);
                        continue block84;
                    }
                    case "ingrowth": {
                        sd.ingrowthXML = tc;
                        continue block84;
                    }
                    case "targetdiameter": {
                        sd.targetDiameter = Double.parseDouble(tc);
                        continue block84;
                    }
                    case "croptreenumber": {
                        sd.cropTreeNumber = this.stripCommentsFromInt(tc, -9);
                        continue block84;
                    }
                    case "heightofthinningstart": {
                        sd.heightOfThinningStart = Double.parseDouble(tc);
                        continue block84;
                    }
                    case "moderatethinning": {
                        sd.moderateThinning = tc;
                        continue block84;
                    }
                    case "color": {
                        sd.colorXML = tc.replace(",", ";");
                        continue block84;
                    }
                    case "competition": {
                        sd.competitionXML = tc;
                        continue block84;
                    }
                    case "mortality": {
                        sd.mortalityXML = tc;
                        continue block84;
                    }
                    case "taperfunction": {
                        sd.taperFunctionXML = tc;
                        continue block84;
                    }
                    case "stemvolumefunction": {
                        sd.stemVolumeFunctionXML = tc;
                        continue block84;
                    }
                    case "coarserootbiomass": {
                        sd.coarseRootBiomass = tc;
                        continue block84;
                    }
                    case "smallrootbiomass": {
                        sd.smallRootBiomass = tc;
                        continue block84;
                    }
                    case "finerootbiomass": {
                        sd.fineRootBiomass = tc;
                        continue block84;
                    }
                    case "totalrootbiomass": {
                        sd.totalRootBiomass = tc;
                        continue block84;
                    }
                    case "uniformheightcurvexml": {
                        sd.uniformHeightCurveXML = this.initTGFunction(tc);
                        continue block84;
                    }
                    case "heightvariation": {
                        sd.heightVariationXML = this.initTGFunction(tc);
                        continue block84;
                    }
                    case "diameterdistributionxml": {
                        sd.diameterDistributionXML = this.initTGFunction(tc);
                        continue block84;
                    }
                    case "volumefunctionxml": {
                        sd.volumeFunctionXML = this.initTGFunction(tc);
                        continue block84;
                    }
                    case "crownwidth": {
                        sd.crownwidthXML = this.initTGFunction(tc);
                        continue block84;
                    }
                    case "crownbase": {
                        sd.crownbaseXML = this.initTGFunction(tc);
                        continue block84;
                    }
                    case "siteindex": {
                        sd.siteindexXML = this.initTGFunction(tc);
                        continue block84;
                    }
                    case "siteindexheight": {
                        sd.siteindexHeightXML = this.initTGFunction(tc);
                        continue block84;
                    }
                    case "potentialheightincrement": {
                        sd.potentialHeightIncrementXML = this.initTGFunction(tc);
                        continue block84;
                    }
                    case "heightincrement": {
                        sd.heightIncrementXML = this.initTGFunction(tc);
                        continue block84;
                    }
                    case "diameterincrement": {
                        sd.diameterIncrementXML = this.initTGFunction(tc);
                        continue block84;
                    }
                    case "maximumdensity": {
                        sd.maximumDensityXML = this.initTGFunction(tc);
                        continue block84;
                    }
                    case "decay": {
                        sd.decayXML = this.initTGFunction(tc);
                        continue block84;
                    }
                    case "diametertreeerror": {
                        sd.diameterTreeErrorXML = tc;
                    }
                }
            }
            if (hlc >= 0 && hlc != sd.code) {
                if (!this.spcdef.containsKey(hlc)) {
                    this.addSpeciesDef(hlc, specDefNodes);
                }
                this.fillUpWithParentValues(sd, this.spcdef.get(hlc));
            }
            String[] rgb = sd.colorXML.split(";");
            sd.colorRed = Integer.parseInt(rgb[0]);
            sd.colorGreen = Integer.parseInt(rgb[1]);
            sd.colorBlue = Integer.parseInt(rgb[2]);
            sd.initPlugins();
            sd.setDefined(true);
            this.spcdef.put(sd.code, sd);
            break;
        }
    }

    private void fillUpWithParentValues(SpeciesDef child, SpeciesDef parent) {
        if (!this.isFunctionDefined(child.uniformHeightCurveXML)) {
            child.uniformHeightCurveXML = this.saveClone(parent.uniformHeightCurveXML);
        }
        if (!this.isFunctionDefined(child.heightVariationXML)) {
            child.heightVariationXML = this.saveClone(parent.heightVariationXML);
        }
        if (!this.isFunctionDefined(child.diameterDistributionXML)) {
            child.diameterDistributionXML = this.saveClone(parent.diameterDistributionXML);
        }
        if (!this.isFunctionDefined(child.volumeFunctionXML)) {
            child.volumeFunctionXML = this.saveClone(parent.volumeFunctionXML);
        }
        if (!this.isFunctionDefined(child.crownwidthXML)) {
            child.crownwidthXML = this.saveClone(parent.crownwidthXML);
        }
        if (!this.isFunctionDefined(child.crownbaseXML)) {
            child.crownbaseXML = this.saveClone(parent.crownbaseXML);
        }
        if (!this.isFunctionDefined(child.siteindexXML)) {
            child.siteindexXML = this.saveClone(parent.siteindexXML);
        }
        if (!this.isFunctionDefined(child.siteindexHeightXML)) {
            child.siteindexHeightXML = this.saveClone(parent.siteindexHeightXML);
        }
        if (!this.isFunctionDefined(child.potentialHeightIncrementXML)) {
            child.potentialHeightIncrementXML = this.saveClone(parent.potentialHeightIncrementXML);
        }
        if (!this.isFunctionDefined(child.heightIncrementXML)) {
            child.heightIncrementXML = this.saveClone(parent.heightIncrementXML);
        }
        if (!this.isFunctionDefined(child.diameterIncrementXML)) {
            child.diameterIncrementXML = this.saveClone(parent.diameterIncrementXML);
        }
        if (!this.isFunctionDefined(child.maximumDensityXML)) {
            child.maximumDensityXML = this.saveClone(parent.maximumDensityXML);
        }
        if (!this.isFunctionDefined(child.decayXML)) {
            child.decayXML = this.saveClone(parent.decayXML);
        }
        if (child.crownType < 0) {
            child.crownType = parent.crownType;
        }
        if (child.heightIncrementError < 0.0) {
            child.heightIncrementError = parent.heightIncrementError;
        }
        if (child.diameterIncrementError < 0.0) {
            child.diameterIncrementError = parent.diameterIncrementError;
        }
        if (child.maximumAge < 0) {
            child.maximumAge = parent.maximumAge;
        }
        if (child.ingrowthXML.isEmpty()) {
            child.ingrowthXML = parent.ingrowthXML;
        }
        if (child.heightCurve < 0) {
            child.heightCurve = parent.heightCurve;
        }
        if (child.targetDiameter < 0.0) {
            child.targetDiameter = parent.targetDiameter;
        }
        if (child.cropTreeNumber < 0) {
            child.cropTreeNumber = parent.cropTreeNumber;
        }
        if (child.heightOfThinningStart < 0.0) {
            child.heightOfThinningStart = parent.heightOfThinningStart;
        }
        if (child.moderateThinning.isEmpty()) {
            child.moderateThinning = parent.moderateThinning;
        }
        if (child.colorXML.isEmpty()) {
            child.colorXML = parent.colorXML;
        }
        if (child.competitionXML.isEmpty()) {
            child.competitionXML = parent.competitionXML;
        }
        if (child.mortalityXML.isEmpty()) {
            child.mortalityXML = parent.mortalityXML;
        }
        if (child.taperFunctionXML.isEmpty()) {
            child.taperFunctionXML = parent.taperFunctionXML;
        }
        if (child.stemVolumeFunctionXML.isEmpty()) {
            try {
                child.stemVolumeFunctionXML = parent.stemVolumeFunctionXML;
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Schaftholz ist: {0}", child.stemVolumeFunctionXML);
            }
        }
        if (child.coarseRootBiomass.isEmpty()) {
            child.coarseRootBiomass = parent.coarseRootBiomass;
        }
        if (child.smallRootBiomass.isEmpty()) {
            child.smallRootBiomass = parent.smallRootBiomass;
        }
        if (child.fineRootBiomass.isEmpty()) {
            child.fineRootBiomass = parent.fineRootBiomass;
        }
        if (child.totalRootBiomass.isEmpty()) {
            child.totalRootBiomass = parent.totalRootBiomass;
        }
    }

    private boolean isFunctionDefined(TGFunction function) {
        return function != null && function.toString().length() > 0;
    }

    private TGFunction saveClone(TGFunction parentFunction) {
        if (parentFunction == null) {
            return null;
        }
        return parentFunction.clone();
    }

    private int stripCommentsFromInt(String orig, int stdValue) {
        if (orig == null || orig.equals("")) {
            return stdValue;
        }
        return Integer.parseInt(orig.split("[/][*].+?[*][/]")[0].trim());
    }

    public TGFunction initTGFunction(String xmlText) {
        if (xmlText == null) {
            return new TGTextFunction();
        }
        if (xmlText.length() == 0) {
            return new TGTextFunction();
        }
        if (xmlText.startsWith("CLASS:")) {
            TGClassFunction f = new TGClassFunction();
            f.init(xmlText);
            return f;
        }
        TGTextFunction f = new TGTextFunction();
        f.init(xmlText);
        return f;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public URL getActualURL() {
        return this.actualurl;
    }

    public int getSize() {
        return this.spcdef.size();
    }

    public int[] getSpeciesCodes() {
        if (this.loaded) {
            int[] list = new int[this.spcdef.size()];
            Iterator<Integer> it = this.spcdef.keySet().iterator();
            int index = 0;
            while (it.hasNext()) {
                list[index] = it.next();
                ++index;
            }
            return list;
        }
        return null;
    }

    public SpeciesDef getByCode(int code) {
        return this.spcdef.get(code);
    }

    public SpeciesDef insertSpecies(int code) {
        if (this.loaded && this.getByCode(code) == null) {
            SpeciesDef spec = new SpeciesDef();
            this.spcdef.put(code, spec);
            return spec;
        }
        return null;
    }

    public void removeSpecies(int code) {
        if (this.loaded) {
            this.spcdef.remove(code);
        }
    }

    public String toString() {
        return "SpeciedDefMap [size: " + this.getSize() + "; URL:" + this.getActualURL().toString() + "]";
    }

    public String listAllSpeciesDefinition(Stand st, String path, String fname) {
        String filename;
        File file = new File(path, fname);
        try {
            filename = file.getCanonicalPath();
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "treegross", ex);
            return null;
        }
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(filename)));){
            out.println("<html><head><title>Simulator Species Definition</title></head><body>");
            out.println("<h2 style=\"text-align:center;\">Simulator Species Definition</h2> ");
            for (int i = 0; i < st.nspecies; ++i) {
                out.println("<p>");
                int m = -9;
                if (st.sp[i].spDef.latinName.contains("http")) {
                    m = st.sp[i].spDef.latinName.indexOf("http") - 1;
                }
                String txt = st.sp[i].spDef.latinName;
                if (m > 1) {
                    txt = "<a href=" + st.sp[i].spDef.latinName.substring(m + 1, st.sp[i].spDef.latinName.length()) + ">" + st.sp[i].spDef.latinName.substring(0, m) + "</a>";
                }
                out.println("</p><p><b>Baumart: " + st.sp[i].code + " " + st.sp[i].spDef.longName + "  " + txt + "</b>");
                out.println("<br>   Kronenbreite [m] = " + st.sp[i].spDef.crownwidthXML);
                out.println("<br>   Kronenansatz [m] = " + st.sp[i].spDef.crownbaseXML);
                out.println("<br>   Bonit\u00f6t      [m] = " + st.sp[i].spDef.siteindexXML);
                out.println("<br>   Potentielle H\u00f6henzuwachs [%] = " + st.sp[i].spDef.potentialHeightIncrementXML);
                out.println("<br>   H\u00f6henzuwachsmodulation [%] = " + st.sp[i].spDef.heightIncrementXML);
                out.println("<br>   Standardabweichung H\u00f6henzuwachs [m] = " + st.sp[i].spDef.heightIncrementError);
                out.println("<br>   Grundfl\u00e4chenzuwachs [cm\u00b2] = " + st.sp[i].spDef.diameterIncrementXML);
                out.println("<br>   Standardabweichung Grundfl\u00e4chenzuwachs [m\u00b2] = " + st.sp[i].spDef.diameterIncrementError);
                out.println("<br>   Baumindividueller Error (Slope, Intercept, General) = " + st.sp[i].spDef.diameterTreeErrorXML);
                out.println("<br>   Maximale Dichte [m\u00b2/ha] = " + st.sp[i].spDef.maximumDensityXML);
                out.println("<br>   Volumenfunktion [m\u00b3] = " + st.sp[i].spDef.volumeFunctionXML);
                out.println("<br>   Durchmesserverteilung : " + st.sp[i].spDef.diameterDistributionXML);
                out.println("<br>   H\u00f6henkurvenfunktion = " + st.sp[i].spDef.heightCurve);
                out.println("<br>   Einheitsh\u00f6henkurve [m] = " + st.sp[i].spDef.uniformHeightCurveXML);
                out.println("<br>   H\u00f6henkurvenvariation [m] = " + st.sp[i].spDef.heightVariationXML);
                out.println("<br>   Totholzzerfall [%] = " + st.sp[i].spDef.decayXML);
                out.println("<br>   Kronendarstellung = " + st.sp[i].spDef.crownType);
                out.println("<br>   Baumartenfarbe [RGB] = " + st.sp[i].spDef.colorXML);
                out.println("</p>");
            }
            out.println("<br>created by TreeGroSS (" + st.modelRegion + ")</br></body></html>");
        }
        catch (FileNotFoundException ex) {
            LOGGER.log(Level.SEVERE, "treegross", ex);
            return null;
        }
        return filename;
    }

    public String listCurrentSpeciesDefinition(Stand st, String path, String fname) throws IOException {
        File file = new File(path, fname);
        String filename = file.getCanonicalPath();
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(filename)));){
            out.println("<html><head><title>Simulator Species Definition</title></head><body>");
            out.println("<h2 style=\"text-align:center;\">Simulator Species Definition</h2> ");
            if (st.nspecies > 0 && st.ingrowthActive) {
                try {
                    String modelPlugIn = st.sp[0].spDef.ingrowthXML;
                    PlugInIngrowth ig = (PlugInIngrowth)Class.forName(modelPlugIn).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    out.println("<p><b>Aktivieres Einwuchsmodell: " + ig.getModelName() + "</b></p>");
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "ERROR in Class Ingrowth2", e);
                }
            }
            for (int i = 0; i < st.nspecies; ++i) {
                out.println("<p>");
                int m = -9;
                if (st.sp[i].spDef.latinName.contains("http")) {
                    m = st.sp[i].spDef.latinName.indexOf("http") - 1;
                }
                String txt = st.sp[i].spDef.latinName;
                if (m > 1) {
                    txt = "<a href=" + st.sp[i].spDef.latinName.substring(m + 1, st.sp[i].spDef.latinName.length()) + ">" + st.sp[i].spDef.latinName.substring(0, m) + "</a>";
                }
                out.println("</p>");
                out.println("<p><b>Baumart: " + st.sp[i].code + " " + st.sp[i].spDef.longName + "  " + txt + "</b>");
                out.println("<br>   Kronenbreite [m] = " + st.sp[i].spDef.crownwidthXML);
                out.println("<br>   Kronenansatz [m] = " + st.sp[i].spDef.crownbaseXML);
                out.println("<br>   Bonit\u00e4t      [m] = " + st.sp[i].spDef.siteindexXML);
                out.println("<br>   Potentielle H\u00f6henzuwachs [%] = " + st.sp[i].spDef.potentialHeightIncrementXML);
                out.println("<br>   H\u00f6henzuwachsmodulation [%] = " + st.sp[i].spDef.heightIncrementXML);
                out.println("<br>   Standardabweichung H\u00f6henzuwachs [m] = " + st.sp[i].spDef.heightIncrementError);
                out.println("<br>   Grundfl\u00e4chenzuwachs [cm\u00b2] = " + st.sp[i].spDef.diameterIncrementXML);
                out.println("<br>   Standardabweichung Grundfl\u00e4chenzuwachs [m\u00b2] = " + st.sp[i].spDef.diameterIncrementError);
                out.println("<br>   Baumindividueller Error (Slope, Intercept, General) = " + st.sp[i].spDef.diameterTreeErrorXML);
                out.println("<br>   Maximale Dichte [m\u00b2/ha] = " + st.sp[i].spDef.maximumDensityXML);
                out.println("<br>   Volumenfunktion [m\u00b3] = " + st.sp[i].spDef.volumeFunctionXML);
                out.println("<br>   Durchmesserverteilung : " + st.sp[i].spDef.diameterDistributionXML);
                out.println("<br>   H\u00f6henkurvenfunktion = " + st.sp[i].spDef.heightCurve);
                out.println("<br>   Einheitsh\u00f6henkurve [m] = " + st.sp[i].spDef.uniformHeightCurveXML);
                out.println("<br>   H\u00f6henkurvenvariation [m] = " + st.sp[i].spDef.heightVariationXML);
                out.println("<br>   Totholzzerfall [%] = " + st.sp[i].spDef.decayXML);
                out.println("<br>   Kronendarstellung = " + st.sp[i].spDef.crownType);
                out.println("<br>   Baumartenfarbe [RGB] = " + st.sp[i].spDef.colorXML);
                out.println("</p>");
            }
            out.println("<br> created by TreeGrOSS (" + st.modelRegion + ")</br></body></html>");
        }
        return filename;
    }

    public String listSpeciesCode(int code, String path, String fname2) {
        String filename;
        File file = new File(path, fname2);
        try {
            filename = file.getCanonicalPath();
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "treegross", ex);
            return null;
        }
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(filename)));){
            out.println("<html><head><title>Simulator Species Definition</title></head><body>");
            out.println("<h2 style=\"text-align:center;\">Species Code</h2><p> ");
            SpeciesDef sd = this.getByCode(code);
            int mm = -9;
            if (sd.latinName.contains("http")) {
                mm = sd.latinName.indexOf("http") - 1;
            }
            String txt = sd.latinName;
            if (mm > 1) {
                txt = "<a href=" + sd.latinName.substring(mm + 1, sd.latinName.length()) + ">" + sd.latinName.substring(0, mm) + "</a>";
            }
            out.println("<br>Baumart: " + sd.code + " " + sd.shortName + " " + sd.longName + " " + txt);
            out.println("<br><hr>created by TreeGrOSS</body></html>");
        }
        catch (FileNotFoundException ex) {
            LOGGER.log(Level.SEVERE, "treegross", ex);
        }
        return filename;
    }
}

