/*
 * Decompiled with CFR 0.152.
 */
package treegross.base;

import java.io.Serializable;
import java.util.Arrays;
import treegross.base.PlugInTaperFunction;

public class TaperFunctionBySchmidt
implements Serializable,
PlugInTaperFunction {
    final double[] a = new double[3];
    final double[] b = new double[3];
    String info = "";
    int numberOfFunctions = 0;
    boolean hardwood = true;
    private int actualFunctionNo = -99;

    @Override
    public void loadParameter(int funNo) {
        if (this.actualFunctionNo == funNo) {
            return;
        }
        this.actualFunctionNo = funNo;
        Arrays.fill(this.b, 0.0);
        this.numberOfFunctions = 5;
        if (funNo == 0) {
            this.info = "beech Schmidt(2001)";
            this.hardwood = true;
            this.a[0] = 0.694614;
            this.a[1] = 0.086273;
            this.a[2] = 0.135984;
        } else if (funNo == 1) {
            this.info = "oak Schmidt(2001)";
            this.hardwood = true;
            this.a[0] = 0.569877;
            this.a[1] = 0.045065;
            this.a[2] = 0.245294;
        } else if (funNo == 2) {
            this.info = "spruce Schmidt(2001)";
            this.hardwood = false;
            this.a[0] = -0.2232695;
            this.a[1] = 1.595027;
            this.a[2] = -3.154957;
            this.b[0] = 0.5119944;
            this.b[1] = -0.1575136;
            this.b[2] = -0.501926;
        } else if (funNo == 3) {
            this.info = "pine Schmidt(2001)";
            this.hardwood = false;
            this.a[0] = -1.725752;
            this.a[1] = 1.331127;
            this.a[2] = -0.701594;
            this.b[0] = 0.0;
            this.b[1] = -0.2141575;
            this.b[2] = 0.130589;
        } else if (funNo == 4) {
            this.info = "Douglas fir Schmidt(2001)";
            this.hardwood = false;
            this.a[0] = -0.5828175;
            this.a[1] = 1.442282;
            this.a[2] = -2.18071;
            this.b[0] = 0.436905;
            this.b[1] = -0.2008;
            this.b[2] = -0.283568;
        } else if (funNo == 5) {
            this.info = "Abies grandis Schmidt(2009)";
            this.hardwood = false;
            this.a[0] = 1.96957;
            this.a[1] = 1.02877;
            this.a[2] = -0.62621;
            this.b[0] = 1.49214;
            this.b[1] = -0.41308;
            this.b[2] = 0.45226;
        } else if (funNo == 6) {
            this.info = "oak Schmidt(2001), Rinde Esche";
            this.hardwood = true;
            this.a[0] = 0.569877;
            this.a[1] = 0.045065;
            this.a[2] = 0.245294;
        } else if (funNo == 7) {
            this.info = "oak Schmidt(2001), mit Rinde Ahorn";
            this.hardwood = true;
            this.a[0] = 0.569877;
            this.a[1] = 0.045065;
            this.a[2] = 0.245294;
        }
    }

    @Override
    public double barkreduce(int funNo, double D) {
        double bark = 0.0;
        switch (funNo) {
            case 0: {
                bark = 2.0355 + 0.2298 * D;
                break;
            }
            case 1: {
                bark = Math.exp(0.9262 + 0.7229 * Math.log(D)) * 1.03;
                break;
            }
            case 2: {
                bark = 3.401 + 0.4363 * D - 0.0018 * D * D;
                break;
            }
            case 3: {
                bark = -0.494 + 0.5639 * D + 0.0062 * D * D;
                break;
            }
            case 4: {
                bark = 1.59099 + 0.50146 * D;
                break;
            }
            case 5: {
                bark = 3.401 + 0.4363 * D - 0.0018 * D * D;
                break;
            }
            case 6: {
                bark = 2.2713 + 0.621 * D;
                break;
            }
            case 7: {
                bark = 1.2355 + 0.3634 * D;
            }
        }
        return bark / 10.0;
    }

    @Override
    public double getDiameterEst(int funNo, double dbh, double height, double h, int barkindex, int sortindex) {
        double diameter;
        this.loadParameter(funNo);
        if (this.hardwood) {
            double i = this.a[0] * dbh / 2.0;
            double u = i / (1.0 - Math.exp(this.a[2] * (1.3 - height))) + (dbh / 2.0 - i) * (1.0 - 1.0 / (1.0 - Math.exp(this.a[1] * (1.3 - height))));
            double v = (dbh / 2.0 - i) * Math.exp(this.a[1] * 1.3) / (1.0 - Math.exp(this.a[1] * (1.3 - height)));
            double w = i * Math.exp(-this.a[2] * height) / (1.0 - Math.exp(this.a[2] * (1.3 - height)));
            if (sortindex == 1) {
                diameter = (int)(2.0 * (u + v * Math.exp(-this.a[1] * h) - w * Math.exp(this.a[2] * h)));
                if (barkindex == 1) {
                    diameter = (double)((int)(2.0 * (u + v * Math.exp(-this.a[1] * h) - w * Math.exp(this.a[2] * h)))) - this.barkreduce(funNo, (double)((int)(2.0 * (u + v * Math.exp(-this.a[1] * h) - w * Math.exp(this.a[2] * h)))) * 1.0);
                }
            } else {
                diameter = 2.0 * (u + v * Math.exp(-this.a[1] * h) - w * Math.exp(this.a[2] * h));
                if (barkindex == 1) {
                    diameter = 2.0 * (u + v * Math.exp(-this.a[1] * h) - w * Math.exp(this.a[2] * h)) - this.barkreduce(funNo, (double)((int)(2.0 * (u + v * Math.exp(-this.a[1] * h) - w * Math.exp(this.a[2] * h)))) * 1.0);
                }
            }
        } else {
            int testa0 = (int)Math.round(this.a[0] * 10.0);
            double Hilfsheight = testa0 == -2 && height / dbh >= 0.5585457 + 1.451182 * Math.exp(Math.log(dbh) * (-0.03046118 * dbh)) ? height : (testa0 == -2 && height / dbh < 0.5585457 + 1.451182 * Math.exp(Math.log(dbh) * (-0.03046118 * dbh)) ? (0.5585457 + 1.451182 * Math.exp(Math.log(dbh) * (-0.03046118 * dbh))) * dbh : (testa0 == -6 && height / dbh >= 0.5548092 + 0.3495206 * Math.exp(Math.log(dbh) * (-0.06206942 * dbh)) ? height : (testa0 == -6 && height / dbh < 0.5548092 + 0.3495206 * Math.exp(Math.log(dbh) * (-0.06206942 * dbh)) ? (0.5548092 + 0.3495206 * Math.exp(Math.log(dbh) * (-0.06206942 * dbh))) * dbh : (testa0 == -17 && height / dbh >= 0.4276964 + 0.9883941 * Math.exp(Math.log(dbh) * (-0.02910625 * dbh)) ? height : (testa0 == -17 && height / dbh < 0.4276964 + 0.9883941 * Math.exp(Math.log(dbh) * (-0.02910625 * dbh)) ? (0.4276964 + 0.9883941 * Math.exp(Math.log(dbh) * (-0.02910625 * dbh))) * dbh : height)))));
            double alpha = this.a[0] + this.a[1] * (1.0 / Math.log(Math.exp(Math.log(Hilfsheight) * (1.0 / dbh)))) + this.a[2] * (1.0 / Math.pow(Hilfsheight / dbh, 2.0));
            double beta = this.b[0] + this.b[1] * (1.0 / Math.log(Math.exp(Math.log(Hilfsheight) * (1.0 / dbh)))) + this.b[2] * (1.0 / Math.pow(Hilfsheight / dbh, 2.0));
            if (sortindex == 1) {
                diameter = (int)(2.0 * (alpha * (1.0 - Math.exp(Math.log(h / height) * 3.0)) + beta * Math.log(h / height)));
                if (barkindex == 1) {
                    diameter = (double)((int)(2.0 * (alpha * (1.0 - Math.exp(Math.log(h / height) * 3.0)) + beta * Math.log(h / height)))) - this.barkreduce(funNo, 1.0 * (double)((int)(2.0 * (alpha * (1.0 - Math.exp(Math.log(h / height) * 3.0)) + beta * Math.log(h / height)))));
                }
            } else {
                diameter = 2.0 * (alpha * (1.0 - Math.exp(Math.log(h / height) * 3.0)) + beta * Math.log(h / height));
                if (barkindex == 1) {
                    diameter = 2.0 * (alpha * (1.0 - Math.exp(Math.log(h / height) * 3.0)) + beta * Math.log(h / height)) - this.barkreduce(funNo, 1.0 * (double)((int)(2.0 * (alpha * (1.0 - Math.exp(Math.log(h / height) * 3.0)) + beta * Math.log(h / height)))));
                }
            }
        }
        return diameter;
    }

    @Override
    public double getLengthEst(int funNo, double dbh, double height, double stemd) {
        double Length;
        double testh1 = 0.0;
        double testh11 = 0.0;
        this.loadParameter(funNo);
        double[] h = new double[1000];
        double testDurchmesser1 = 150.0;
        if (this.hardwood) {
            double Durchmesser;
            double testDurchmesser2;
            double i = this.a[0] * dbh / 2.0;
            double u = i / (1.0 - Math.exp(this.a[2] * (1.3 - height))) + (dbh / 2.0 - i) * (1.0 - 1.0 / (1.0 - Math.exp(this.a[1] * (1.3 - height))));
            double v = (dbh / 2.0 - i) * Math.exp(this.a[1] * 1.3) / (1.0 - Math.exp(this.a[1] * (1.3 - height)));
            double w = i * Math.exp(-this.a[2] * height) / (1.0 - Math.exp(this.a[2] * (1.3 - height)));
            for (int j = 1; j <= 500; ++j) {
                h[j] = j / 10;
                if (!(h[j] < height) || !(Math.abs(testDurchmesser2 = (Durchmesser = 2.0 * (u + v * Math.exp(-this.a[1] * h[j]) - w * Math.exp(this.a[2] * h[j]))) - stemd) <= testDurchmesser1)) continue;
                testDurchmesser1 = Math.abs(testDurchmesser2);
                testh1 = h[j];
            }
            for (int r = -9; r <= 9; ++r) {
                double testh2 = testh1 + (double)(r / 100);
                if (!(testh2 < height) || !(Math.abs(testDurchmesser2 = (Durchmesser = 2.0 * (u + v * Math.exp(-this.a[1] * testh2) - w * Math.exp(this.a[2] * testh2))) - stemd) <= testDurchmesser1)) continue;
                testDurchmesser1 = Math.abs(testDurchmesser2);
                testh11 = testh2;
            }
            Length = testh11;
        } else {
            double Durchmesser;
            double testDurchmesser2;
            int testa0 = (int)Math.round(this.a[0] * 10.0);
            double Hilfshoehe = testa0 == -2 && height / dbh >= 0.5585457 + 1.451182 * Math.exp(Math.log(dbh) * (-0.03046118 * dbh)) ? height : (testa0 == -2 && height / dbh < 0.5585457 + 1.451182 * Math.exp(Math.log(dbh) * (-0.03046118 * dbh)) ? (0.5585457 + 1.451182 * Math.exp(Math.log(dbh) * (-0.03046118 * dbh))) * dbh : (testa0 == -6 && height / dbh >= 0.5548092 + 0.3495206 * Math.exp(Math.log(dbh) * (-0.06206942 * dbh)) ? height : (testa0 == -6 && height / dbh < 0.5548092 + 0.3495206 * Math.exp(Math.log(dbh) * (-0.06206942 * dbh)) ? (0.5548092 + 0.3495206 * Math.exp(Math.log(dbh) * (-0.06206942 * dbh))) * dbh : (testa0 == -17 && height / dbh >= 0.4276964 + 0.9883941 * Math.exp(Math.log(dbh) * (-0.02910625 * dbh)) ? height : (testa0 == -17 && height / dbh < 0.4276964 + 0.9883941 * Math.exp(Math.log(dbh) * (-0.02910625 * dbh)) ? (0.4276964 + 0.9883941 * Math.exp(Math.log(dbh) * (-0.02910625 * dbh))) * dbh : height)))));
            double alpha = this.a[0] + this.a[1] * (1.0 / Math.log(Math.exp(Math.log(Hilfshoehe) * (1.0 / dbh)))) + this.a[2] * (1.0 / Math.pow(Hilfshoehe / dbh, 2.0));
            double beta = this.b[0] + this.b[1] * (1.0 / Math.log(Math.exp(Math.log(Hilfshoehe) * (1.0 / dbh)))) + this.b[2] * (1.0 / Math.pow(Hilfshoehe / dbh, 2.0));
            for (int j = 1; j <= 600; ++j) {
                h[j] = j / 10;
                if (!(h[j] < height) || !(Math.abs(testDurchmesser2 = (Durchmesser = 2.0 * (alpha * (1.0 - Math.exp(Math.log(h[j] / height) * 3.0)) + beta * Math.log(h[j] / height))) - stemd) < testDurchmesser1)) continue;
                testDurchmesser1 = Math.abs(testDurchmesser2);
                testh1 = h[j];
            }
            for (int r = -9; r <= 9; ++r) {
                double testh2 = testh1 + (double)(r / 100);
                if (!(testh2 < height) || !(Math.abs(testDurchmesser2 = (Durchmesser = 2.0 * (alpha * (1.0 - Math.exp(Math.log(testh2 / height) * 3.0)) + beta * Math.log(testh2 / height))) - stemd) <= testDurchmesser1)) continue;
                testDurchmesser1 = Math.abs(testDurchmesser2);
                testh11 = testh2;
            }
            Length = testh11;
        }
        return Length;
    }

    @Override
    public double getCumVolume(int funNo, double dbh, double height, double h, int barkindex, int sortindex) {
        double r = 0.0;
        double Volsum = 0.0;
        if (!this.hardwood) {
            if (h > 0.6) {
                double Vol;
                int i;
                for (i = 15; i <= (int)(h * 25.0); ++i) {
                    r = i * 4;
                    Vol = 4.1887902047863905 * (Math.pow(this.getDiameterEst(funNo, dbh, height, r / 100.0, barkindex, sortindex) / 2.0, 2.0) + this.getDiameterEst(funNo, dbh, height, r / 100.0, barkindex, sortindex) / 2.0 * this.getDiameterEst(funNo, dbh, height, (r + 4.0) / 100.0, barkindex, sortindex) / 2.0 + Math.pow(this.getDiameterEst(funNo, dbh, height, (r + 4.0) / 100.0, barkindex, sortindex) / 2.0, 2.0));
                    Volsum += Vol / 1000000.0;
                }
                if ((int)(h * 25.0 * 4.0) < (int)(h * 100.0)) {
                    for (i = (int)(h * 25.0 * 4.0); i <= (int)(h * 100.0); ++i) {
                        r = i;
                        Vol = 1.0471975511965976 * (Math.pow(this.getDiameterEst(funNo, dbh, height, r / 100.0, barkindex, sortindex) / 2.0, 2.0) + this.getDiameterEst(funNo, dbh, height, r / 100.0, barkindex, sortindex) / 2.0 * this.getDiameterEst(funNo, dbh, height, (r + 1.0) / 100.0, barkindex, sortindex) / 2.0 + Math.pow(this.getDiameterEst(funNo, dbh, height, (r + 1.0) / 100.0, barkindex, sortindex) / 2.0, 2.0));
                        Volsum += Vol / 1000000.0;
                    }
                }
                double Extrapol = this.getDiameterEst(funNo, dbh, height, 0.6, barkindex, sortindex) - this.getDiameterEst(funNo, dbh, height, 1.2, barkindex, sortindex) + this.getDiameterEst(funNo, dbh, height, 0.6, barkindex, sortindex);
                Vol = 62.831853071795855 * (Math.pow(this.getDiameterEst(funNo, dbh, height, 0.6, barkindex, sortindex) / 2.0, 2.0) + this.getDiameterEst(funNo, dbh, height, 0.6, barkindex, sortindex) / 2.0 * Extrapol / 2.0 + Math.pow(Extrapol / 2.0, 2.0));
                Volsum += Vol / 1000000.0;
            } else {
                double Extrapol = this.getDiameterEst(funNo, dbh, height, 0.6, barkindex, sortindex) - this.getDiameterEst(funNo, dbh, height, 1.2, barkindex, sortindex) + this.getDiameterEst(funNo, dbh, height, 0.6, barkindex, sortindex);
                double Vol = Math.PI * h * 100.0 / 3.0 * (Math.pow(this.getDiameterEst(funNo, dbh, height, 0.6, barkindex, sortindex) / 2.0, 2.0) + this.getDiameterEst(funNo, dbh, height, 0.6, barkindex, sortindex) / 2.0 * Extrapol / 2.0 + Math.pow(Extrapol / 2.0, 2.0));
                Volsum += Vol / 1000000.0;
            }
        } else {
            double Vol;
            int i;
            for (i = 1; i <= (int)(h * 25.0); ++i) {
                r = i * 4;
                Vol = 4.1887902047863905 * (Math.pow(this.getDiameterEst(funNo, dbh, height, r / 100.0, barkindex, sortindex) / 2.0, 2.0) + this.getDiameterEst(funNo, dbh, height, r / 100.0, barkindex, sortindex) / 2.0 * this.getDiameterEst(funNo, dbh, height, (r + 4.0) / 100.0, barkindex, sortindex) / 2.0 + Math.pow(this.getDiameterEst(funNo, dbh, height, (r + 4.0) / 100.0, barkindex, sortindex) / 2.0, 2.0));
                Volsum += Vol / 1000000.0;
            }
            if ((int)(h * 25.0) * 4 < (int)(h * 100.0)) {
                for (i = (int)(h * 25.0 * 4.0); i <= (int)(h * 100.0); ++i) {
                    Vol = 1.0471975511965976 * (Math.pow(this.getDiameterEst(funNo, dbh, height, r / 100.0, barkindex, sortindex) / 2.0, 2.0) + this.getDiameterEst(funNo, dbh, height, r / 100.0, barkindex, sortindex) / 2.0 * this.getDiameterEst(funNo, dbh, height, (r + 1.0) / 100.0, barkindex, sortindex) / 2.0 + Math.pow(this.getDiameterEst(funNo, dbh, height, (r + 1.0) / 100.0, barkindex, sortindex) / 2.0, 2.0));
                    Volsum += Vol / 1000000.0;
                }
            }
        }
        return Volsum;
    }

    @Override
    public int getNumberOfFunctions() {
        this.loadParameter(0);
        return this.numberOfFunctions;
    }

    @Override
    public String getFunctionName(int funNo) {
        this.loadParameter(funNo);
        return this.info;
    }

    @Override
    public int getFunctionNumber(int speciesCode) {
        int funNo = 0;
        if (speciesCode < 100) {
            funNo = 0;
        }
        if (speciesCode >= 100 && speciesCode < 200) {
            funNo = 1;
        }
        if (speciesCode >= 200 && speciesCode < 500) {
            funNo = 0;
        }
        if (speciesCode >= 500) {
            funNo = 2;
        }
        if (speciesCode >= 700 && speciesCode < 800) {
            funNo = 3;
        }
        if (speciesCode == 611) {
            funNo = 4;
        }
        if (speciesCode == 523) {
            funNo = 5;
        }
        if (speciesCode == 311) {
            funNo = 6;
        }
        if (speciesCode >= 320 && speciesCode < 323) {
            funNo = 7;
        }
        return funNo;
    }
}

