/*
 * Decompiled with CFR 0.152.
 */
package treegross.tools;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlTool {
    public static Element addChild(Element toElt, String name) {
        Element newElt = toElt.getOwnerDocument().createElement(name);
        toElt.appendChild(newElt);
        return newElt;
    }

    public static Element addChildString(Element toElt, String name, String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        Element newElt = toElt.getOwnerDocument().createElement(name);
        newElt.appendChild(toElt.getOwnerDocument().createTextNode(text));
        toElt.appendChild(newElt);
        return newElt;
    }

    public static Node getChild(Node n, String childName) {
        String childNameLower = childName.toLowerCase();
        NodeList modelNodes = n.getChildNodes();
        for (int j = 0; j < modelNodes.getLength(); ++j) {
            String nn;
            Node m = modelNodes.item(j);
            if (m.getNodeType() != 1 || !(nn = m.getNodeName().toLowerCase()).equals(childNameLower)) continue;
            return m;
        }
        return null;
    }

    public static List<Node> getChilds(Node n, String childName) {
        if (n == null) {
            return null;
        }
        String childNameLower = childName.toLowerCase();
        NodeList modelNodes = n.getChildNodes();
        ArrayList<Node> nl = new ArrayList<Node>();
        for (int j = 0; j < modelNodes.getLength(); ++j) {
            String nn;
            Node m = modelNodes.item(j);
            if (m.getNodeType() != 1 || !(nn = m.getNodeName().toLowerCase()).equals(childNameLower)) continue;
            nl.add(m);
        }
        return nl;
    }

    public static String getChildText(Node n, String childName, String defaultIfNull) {
        String result = XmlTool.getChildText(n, childName);
        return result == null ? defaultIfNull : result;
    }

    public static String getChildText(Node n, String childName) {
        String tc;
        if (n == null) {
            return null;
        }
        String result = null;
        Node cn = XmlTool.getChild(n, childName);
        if (cn != null && (tc = cn.getTextContent()) != null) {
            result = tc;
        }
        return result;
    }
}

