/*
 * Decompiled with CFR 0.152.
 */
package treegross.treatment;

import treegross.base.Stand;
import treegross.base.Tree;
import treegross.treatment.CropTreeSpecies;

public class CropTreeSelection {
    public void selectCropTrees(Stand st, CropTreeSpecies[] ctsp) {
        int i;
        int a;
        for (int a2 = 0; a2 < st.ntrees - 1; ++a2) {
            for (int b = a2 + 1; b < st.ntrees; ++b) {
                if (!(st.tr[a2].d < st.tr[b].d)) continue;
                Tree trtemp = st.tr[a2];
                st.tr[a2] = st.tr[b];
                st.tr[b] = trtemp;
            }
        }
        for (a = 0; a < st.nspecies - 1; ++a) {
            for (int b = a + 1; b < st.nspecies; ++b) {
                if (!(ctsp[a].nha > ctsp[b].nha)) continue;
                CropTreeSpecies ctsptemp = ctsp[a];
                ctsp[a] = ctsp[b];
                ctsp[b] = ctsptemp;
            }
        }
        int sumCT = 0;
        for (a = 0; a < st.nspecies; ++a) {
            int nCTSp_a = (int)(ctsp[a].nha * st.size);
            sumCT += nCTSp_a;
        }
        boolean endselection = false;
        int rIndex = 0;
        do {
            boolean selectedspecies = true;
            for (i = 0; i < st.nspecies; ++i) {
                boolean enoughtreesofspecies;
                int j = 0;
                boolean selectedtree = false;
                int nCTSpTarget = (int)(ctsp[i].nha * st.size);
                int nselectedcroptrees = this.getNcroptrees(st, ctsp[i].code);
                boolean bl = enoughtreesofspecies = nselectedcroptrees >= nCTSpTarget;
                if (!enoughtreesofspecies) {
                    selectedtree = false;
                    do {
                        if (st.ntrees <= 0 || !(st.h100 >= ctsp[i].min_height) || ctsp[i].code != st.tr[j].code || !(st.tr[j].d >= 7.0) || st.tr[j].outtype > 0 || st.tr[j].crop || st.tr[j].habitat || !(st.tr[j].h > st.tr[j].sp.trule.minCropTreeHeight)) continue;
                        double distNearest = Double.POSITIVE_INFINITY;
                        for (int m = 0; m < st.ntrees; ++m) {
                            double distYS;
                            double distXS;
                            double dist;
                            if ((!st.tr[m].crop || st.tr[m].outtype > 0) && (!st.tr[m].habitat || st.tr[m].outtype > 0) || !((dist = Math.sqrt((distXS = (st.tr[j].x - st.tr[m].x) * (st.tr[j].x - st.tr[m].x)) + (distYS = (st.tr[j].y - st.tr[m].y) * (st.tr[j].y - st.tr[m].y)))) < distNearest)) continue;
                            distNearest = dist;
                            for (int n = 0; n < st.nspecies; ++n) {
                                if (ctsp[n].code != st.tr[m].code) continue;
                                rIndex = n;
                            }
                        }
                        if (!(distNearest > ctsp[i].dist * 0.5 + ctsp[rIndex].dist * 0.5)) continue;
                        st.tr[j].crop = true;
                        selectedtree = true;
                    } while (!selectedtree && ++j < st.ntrees);
                }
                if (!selectedtree) continue;
                selectedspecies = false;
            }
            if (!selectedspecies) continue;
            endselection = true;
        } while (!endselection);
        for (i = 0; i < st.nspecies; ++i) {
            this.getNcroptrees(st, ctsp[i].code);
        }
    }

    public void selectTempCropTrees(Stand st, CropTreeSpecies[] ctsp) {
        int a;
        for (int a2 = 0; a2 < st.ntrees - 1; ++a2) {
            for (int b = a2 + 1; b < st.ntrees; ++b) {
                if (!(st.tr[a2].d < st.tr[b].d)) continue;
                Tree trtemp = st.tr[a2];
                st.tr[a2] = st.tr[b];
                st.tr[b] = trtemp;
            }
        }
        for (a = 0; a < st.nspecies - 1; ++a) {
            for (int b = a + 1; b < st.nspecies; ++b) {
                if (!(ctsp[a].nha > ctsp[b].nha)) continue;
                CropTreeSpecies ctsptemp = ctsp[a];
                ctsp[a] = ctsp[b];
                ctsp[b] = ctsptemp;
            }
        }
        int sumCT = 0;
        for (a = 0; a < st.nspecies; ++a) {
            int nCTSp_a = (int)(ctsp[a].nha * st.size);
            sumCT += nCTSp_a;
        }
        boolean endselection = false;
        int rIndex = 0;
        do {
            boolean selectedspecies = true;
            for (int i = 0; i < st.nspecies; ++i) {
                boolean enoughtreesofspecies;
                int j = 0;
                boolean selectedtree = false;
                int nCTSpTarget = (int)(ctsp[i].nha * st.size);
                int nselectedcroptrees = this.getNcroptrees(st, ctsp[i].code);
                boolean bl = enoughtreesofspecies = nselectedcroptrees >= nCTSpTarget;
                if (!enoughtreesofspecies) {
                    selectedtree = false;
                    do {
                        if (st.ntrees <= 0 || !(st.h100 >= ctsp[i].min_height) || ctsp[i].code != st.tr[j].code || st.tr[j].outtype > 0 || st.tr[j].crop || st.tr[j].tempcrop || st.tr[j].habitat) continue;
                        double distNearest = 99999.9;
                        for (int m = 0; m < st.ntrees; ++m) {
                            double distYS;
                            double distXS;
                            double dist;
                            if (!(st.tr[m].crop && st.tr[m].outtype <= 0 || st.tr[m].tempcrop && st.tr[m].outtype <= 0) && (!st.tr[m].habitat || st.tr[m].outtype > 0) || !((dist = Math.sqrt((distXS = (st.tr[j].x - st.tr[m].x) * (st.tr[j].x - st.tr[m].x)) + (distYS = (st.tr[j].y - st.tr[m].y) * (st.tr[j].y - st.tr[m].y)))) < distNearest)) continue;
                            distNearest = dist;
                            for (int n = 0; n < st.nspecies; ++n) {
                                if (ctsp[n].code != st.tr[m].code) continue;
                                rIndex = n;
                            }
                        }
                        if (!(distNearest > ctsp[i].dist * 0.5 + ctsp[rIndex].dist * 0.5)) continue;
                        st.tr[j].tempcrop = true;
                        selectedtree = true;
                    } while (!selectedtree && ++j < st.ntrees);
                }
                if (!selectedtree) continue;
                selectedspecies = false;
            }
            if (!selectedspecies) continue;
            endselection = true;
        } while (!endselection);
    }

    public int getNcroptrees(Stand st, int spe) {
        int m = 0;
        for (int i = 0; i < st.ntrees; ++i) {
            if (st.tr[i].out >= 0 || !st.tr[i].crop || st.tr[i].code != spe && spe != 0) continue;
            ++m;
        }
        return m;
    }

    public int getNallcroptrees(Stand st, int spe) {
        int m = 0;
        for (int i = 0; i < st.ntrees; ++i) {
            if ((st.tr[i].out >= 0 || !st.tr[i].crop || st.tr[i].code != spe && spe != 0) && (st.tr[i].out >= 0 || !st.tr[i].tempcrop || st.tr[i].code != spe && spe != 0)) continue;
            ++m;
        }
        return m;
    }

    public void resetAllCropTrees(Stand st) {
        for (int i = 0; i < st.ntrees; ++i) {
            st.tr[i].crop = false;
            st.tr[i].tempcrop = false;
        }
    }

    void resetTempCropTrees(Stand st) {
        for (int i = 0; i < st.ntrees; ++i) {
            st.tr[i].tempcrop = false;
        }
    }

    void resetCropTrees(Stand st) {
        for (int i = 0; i < st.ntrees; ++i) {
            st.tr[i].crop = false;
        }
    }
}

