/*
 * Decompiled with CFR 0.152.
 */
package treegross.treatment;

import treegross.base.Stand;
import treegross.treatment.TreatmentElements2;

public class Treatment2 {
    public static final int HT_TARGET_DIAMETER = 0;
    public static final int HT_TARGET_DIAMETER_PERIOD = 1;
    public static final int HT_SCHIRMSCHLAG = 8;
    public static final int HT_CLEAR_CUT = 9;
    public static final int HT_BY_GAPS = 3;
    public static final int TT_SINGLE_TREE_SELECTION = 0;
    public static final int TT_FROM_ABOVE = 1;
    public static final int TT_FROM_BELOW = 2;
    public static final int TT_QD = 3;
    public static final int TT_CROP_TREE_MIX = 4;
    public static final int TT_CLEAR_CUT = 9;
    TreatmentElements2 te = new TreatmentElements2();

    public void executeManager2(Stand st) {
        st.sortbyd();
        st.descspecies();
        if (st.status == 0) {
            st.status = 1;
        }
        st.trule.minOutVolume = st.trule.minHarvestVolume <= st.trule.minThinningVolume ? st.trule.minHarvestVolume : st.trule.minThinningVolume;
        st.trule.maxOutVolume = st.trule.maxHarvestVolume >= st.trule.maxThinningVolume ? st.trule.maxHarvestVolume : st.trule.maxThinningVolume;
        if (st.year > st.trule.lastTreatment) {
            this.te.resetOutTake(st);
        }
        if (st.trule.skidtrails) {
            this.te.createSkidtrails(st);
        }
        if (st.year >= st.trule.lastTreatment + st.trule.treatmentStep || st.year == st.trule.lastTreatment) {
            this.te.markTreesAsHabitatTreesByDiameter(st);
            if (st.trule.nHabitat > 0.0) {
                this.te.selectHabitatTrees(st);
            }
            if (st.trule.protectMinorities) {
                this.te.SelectOneCropTreePerSpecies(st, true);
            }
            boolean finalCut = false;
            if (st.degreeOfDensity < st.trule.degreeOfStockingToClearOverStoryStand && st.status > 1) {
                this.te.harvestRemainingTrees(st, true, -1, 1.3);
                finalCut = true;
            } else {
                if (st.trule.typeOfHarvest == 0) {
                    this.te.harvestTargetDiameter(st);
                }
                if (st.trule.typeOfHarvest == 1 && (this.te.percentOfBasalAreaAboveTargetDiameter(st) > 0.3 || st.status > 1)) {
                    this.te.harvestTargetDiameterInPeriod(st);
                }
                if (st.trule.typeOfHarvest == 8 && (this.te.percentOfBasalAreaAboveTargetDiameter(st) > 0.3 || st.status > 1)) {
                    this.te.harvestSchirmschlag(st);
                }
                if (st.trule.typeOfHarvest == 9 && this.te.percentOfBasalAreaAboveTargetDiameter(st) > 0.3 || st.status > 98) {
                    this.te.harvestClearCut(st);
                }
                if (st.trule.typeOfHarvest == 3) {
                    this.te.harvestByGaps(st);
                }
                this.te.checkMinHarvestVolume(st);
            }
            double sumcroptrees = 0.0;
            for (int i = 0; i < st.nspecies; ++i) {
                sumcroptrees += (double)st.sp[i].trule.numberCropTreesWanted;
            }
            if (this.te.getNCropTrees(st) > sumcroptrees * st.size) {
                this.te.resetCropTrees(st);
            }
            if ((this.te.getNCropTrees(st) <= 0.0 || st.trule.reselectCropTrees) && st.trule.selectCropTrees) {
                this.te.selectNCropTrees(st);
            }
            if (st.trule.releaseCropTrees && st.trule.typeOfThinning == 0) {
                this.te.thinCropTreeCompetition(st);
                if (st.trule.thinArea) {
                    this.te.thinCompetitionFromAbove(st);
                }
            }
            if (st.trule.typeOfThinning == 1) {
                this.te.resetTempCropTrees(st);
                this.te.selectTempCropTreesTargetPercentage(st);
                this.te.thinTempCropTreeCompetition(st);
                if (st.trule.thinArea) {
                    this.te.thinCompetitionFromAbove(st);
                }
            }
            if (st.trule.typeOfThinning == 2) {
                this.te.thinFromBelow(st);
            }
            if (st.trule.typeOfThinning == 3) {
                this.te.thinByQD(st);
            }
            if (st.trule.typeOfThinning == 4) {
                this.te.thinCropTreeCompetition2(st);
                this.te.thinCompetitionFromAbove2(st);
            }
            this.te.checkMinThinningVolume(st);
            if (!finalCut) {
                this.te.checkMinTreatmentOutVolume(st);
            }
        }
        if (this.te.getHarvestedOutVolume(st) > 0.0 || this.te.getThinnedOutVolume(st) > 0.0) {
            st.trule.lastTreatment = st.year;
        }
        if (st.trule.autoPlanting && this.te.getDegreeOfCover(0, st, false) < st.trule.degreeOfStockingToStartPlanting) {
            if (st.trule.onPlantingRemoveAllTrees) {
                int ps = -1;
                if (st.trule.plantingString.length() >= 3) {
                    ps = Integer.parseInt(st.trule.plantingString.substring(0, 3));
                }
                this.te.harvestRemainingTrees(st, false, ps, 10.0);
            }
            this.te.startPlanting(st);
        }
    }

    public void updateStandAfterThinning(Stand st) {
        st.sortbyd();
        st.descspecies();
    }

    public void resetAllCropTrees(Stand st) {
        this.te.resetTempCropTrees(st);
        this.te.resetCropTrees(st);
    }

    public void setSkidTrails(Stand st, boolean active, double trailDistance, double trailWidth) {
        st.trule.skidtrails = active;
        st.trule.skidtrailDistance = trailDistance;
        st.trule.skidtrailWidth = trailWidth;
    }

    public void setThinningRegime(Stand st, int type, double intensity, double minVolume, double maxVolume, boolean croptreesOnly) {
        st.trule.thinAreaSpeciesDependent = true;
        st.trule.thinArea = true;
        st.trule.selectCropTrees = false;
        st.trule.reselectCropTrees = false;
        st.trule.releaseCropTrees = false;
        st.trule.cutCompetingCropTrees = false;
        st.trule.releaseCropTreesSpeciesDependent = false;
        st.trule.minThinningVolume = minVolume;
        st.trule.maxThinningVolume = maxVolume;
        st.trule.thinningIntensity = intensity;
        if (type == 0) {
            st.trule.typeOfThinning = 0;
            st.trule.thinArea = true;
            if (croptreesOnly) {
                st.trule.thinArea = false;
            }
            st.trule.selectCropTrees = true;
            st.trule.reselectCropTrees = true;
            st.trule.selectCropTreesOfAllSpecies = false;
            st.trule.releaseCropTrees = true;
            st.trule.cutCompetingCropTrees = true;
            st.trule.releaseCropTreesSpeciesDependent = true;
        }
        if (type == 1) {
            st.trule.typeOfThinning = 1;
            st.trule.selectCropTreesOfAllSpecies = false;
        }
        if (type == 2) {
            st.trule.typeOfThinning = 2;
        }
        if (type == 3) {
            st.trule.typeOfThinning = 3;
            st.trule.thinArea = false;
            if (croptreesOnly) {
                st.trule.thinArea = false;
            }
            st.trule.selectCropTrees = true;
            st.trule.reselectCropTrees = true;
            st.trule.selectCropTreesOfAllSpecies = false;
            st.trule.releaseCropTrees = true;
            st.trule.cutCompetingCropTrees = true;
            st.trule.releaseCropTreesSpeciesDependent = true;
        }
        if (type == 4) {
            st.trule.typeOfThinning = 4;
            st.trule.thinArea = true;
            if (croptreesOnly) {
                st.trule.thinArea = false;
            }
            st.trule.selectCropTrees = true;
            st.trule.reselectCropTrees = true;
            st.trule.selectCropTreesOfAllSpecies = false;
            st.trule.releaseCropTrees = true;
            st.trule.cutCompetingCropTrees = true;
            st.trule.releaseCropTreesSpeciesDependent = true;
        }
    }

    public void setHarvestRegime(Stand st, int type, double minVolume, double maxVolume, double degreeToClear, String regenerationProc) {
        st.trule.minHarvestVolume = minVolume;
        st.trule.maxHarvestVolume = maxVolume;
        st.trule.harvestLayerFromBelow = false;
        if (type == 0) {
            st.trule.typeOfHarvest = 0;
            st.trule.maxHarvestingPeriode = 6;
            st.trule.lastTreatment = 0;
            st.trule.degreeOfStockingToClearOverStoryStand = degreeToClear;
        }
        if (type == 1 || type == 4) {
            st.trule.minThinningVolume = 0.0;
            st.trule.maxThinningVolume = 900.0;
            st.trule.thinningIntensityArea = 0.0;
            st.trule.minHarvestVolume = 0.0;
            st.trule.maxHarvestVolume = 500.0;
            st.trule.typeOfHarvest = type == 1 ? 8 : 1;
            st.trule.cutCompetingCropTrees = true;
            st.trule.startOfHarvest = 0;
            st.trule.regenerationProcess = regenerationProc;
            st.trule.reselectCropTrees = true;
            st.trule.degreeOfStockingToClearOverStoryStand = 0.0;
        }
        if (type == 2) {
            st.trule.thinningIntensityArea = 0.0;
            st.trule.minHarvestVolume = 0.0;
            st.trule.maxHarvestVolume = 99999.0;
            st.trule.typeOfHarvest = 9;
            st.trule.maxHarvestingPeriode = 0;
            st.trule.lastTreatment = 0;
        }
        if (type == 3) {
            st.trule.thinningIntensityArea = 0.0;
            st.trule.typeOfHarvest = 3;
            st.trule.maxHarvestingPeriode = 0;
            st.trule.lastTreatment = 0;
            st.trule.reselectCropTrees = true;
        }
    }

    public void setNatureProtection(Stand st, int habitatTrees, int typeOfHabitat, boolean minority, double minStocking, int diameterProtection) {
        st.trule.protectMinorities = minority;
        st.trule.nHabitat = habitatTrees;
        st.trule.habitatTreeType = typeOfHabitat;
        st.trule.minimumCoverage = minStocking;
        st.trule.treeProtectedfromBHD = diameterProtection;
    }

    public void setAutoPlanting(Stand st, boolean active, boolean clearArea, double critCoverage, String plantingStr) {
        st.trule.autoPlanting = active;
        st.trule.onPlantingRemoveAllTrees = clearArea;
        st.trule.degreeOfStockingToStartPlanting = critCoverage;
        st.trule.plantingString = plantingStr;
    }

    public void setBT(Stand st) {
        if (st.bt > 0) {
            int art1 = (int)Math.floor(st.bt / 10);
            int art2 = st.bt - art1 * 10;
            int mixPerc1 = 100;
            int mixPerc2 = 0;
            if (art2 > 0) {
                mixPerc1 = 70;
                mixPerc2 = 30;
            }
            for (int i = 0; i < st.nspecies; ++i) {
                st.sp[i].trule.targetCrownPercent = 0.0;
                st.sp[i].trule.numberCropTreesWanted = 0;
            }
            for (int k = 0; k < 2; ++k) {
                int art = art1;
                int mix = mixPerc1;
                if (k > 0) {
                    art = art2;
                    mix = mixPerc2;
                }
                for (int i = 0; i < st.nspecies; ++i) {
                    int j;
                    double anz;
                    if (art == 1 && (st.sp[i].code == 111 || st.sp[i].code == 112)) {
                        anz = 0.0;
                        for (j = 0; j < st.nspecies; ++j) {
                            if (st.sp[j].code != 111 && st.sp[j].code != 112) continue;
                            anz += 1.0;
                        }
                        st.sp[i].trule.targetCrownPercent = mix;
                        st.sp[i].trule.numberCropTreesWanted = (int)Math.round((double)(1 * mix) / anz);
                    }
                    if (art == 2 && st.sp[i].code == 211) {
                        st.sp[i].trule.targetCrownPercent = mix;
                        st.sp[i].trule.numberCropTreesWanted = (int)Math.round(1.2 * (double)mix);
                    }
                    if (art == 3 && (st.sp[i].code == 311 || st.sp[i].code == 321)) {
                        anz = 0.0;
                        for (j = 0; j < st.nspecies; ++j) {
                            if (st.sp[j].code != 311 && st.sp[j].code != 321) continue;
                            anz += 1.0;
                        }
                        st.sp[i].trule.targetCrownPercent = mix;
                        st.sp[i].trule.numberCropTreesWanted = (int)Math.round(1.2 * (double)mix / anz);
                    }
                    if (art == 4 && st.sp[i].code == 421) {
                        st.sp[i].trule.targetCrownPercent = mix;
                        st.sp[i].trule.numberCropTreesWanted = (int)Math.round(1.2 * (double)mix);
                    }
                    if (art == 5 && st.sp[i].code == 511) {
                        st.sp[i].trule.targetCrownPercent = mix;
                        st.sp[i].trule.numberCropTreesWanted = (int)Math.round(2.0 * (double)mix);
                    }
                    if (art == 6 && st.sp[i].code == 611) {
                        st.sp[i].trule.targetCrownPercent = mix;
                        st.sp[i].trule.numberCropTreesWanted = (int)Math.round(1.8 * (double)mix);
                    }
                    if (art == 7 && st.sp[i].code == 711) {
                        st.sp[i].trule.targetCrownPercent = mix;
                        st.sp[i].trule.numberCropTreesWanted = (int)Math.round(2.0 * (double)mix);
                    }
                    if (art != 8 || st.sp[i].code != 811) continue;
                    st.sp[i].trule.targetCrownPercent = mix;
                    st.sp[i].trule.numberCropTreesWanted = (int)Math.round(2.0 * (double)mix);
                }
            }
        }
    }

    public String getPlantingStr(int wet) {
        String txt = "211[1.0];";
        if (wet > 0) {
            int art1 = (int)Math.floor(wet / 10);
            int art2 = wet - art1 * 10;
            Double mixPerc1 = 1.0;
            Double mixPerc2 = 0.0;
            if (art2 > 0) {
                mixPerc1 = 0.7;
                mixPerc2 = 0.3;
            }
            txt = art1 + "11[" + mixPerc1.toString() + "];";
            if (art2 > 0) {
                txt = txt + art2 + "11[" + mixPerc2.toString() + "];";
            }
        }
        return txt;
    }
}

