/*
    (c) 2002 - 2022 Juergen Nagel, Jan Hansen
    Northwest German Forest Research Station (https://www.nw-fva.de), 
    Grätzelstr. 2, 37079 Göttingen, Germany
    E-Mail: Jan.Hansen@nw-fva.de
 
    This file is part of the TreeGrOSS libraray.

    TreeGrOSS is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    TreeGrOSS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with TreeGrOSS. If not, see http://www.gnu.org/licenses/.
*/

package treegross.random;

import java.util.Random;

/**
 *
 * @author jhansen
 *
 * this list stores 1000 pseudo random numbers the random numbers are normally
 * distributed with mean 0 and standard deviation 1 the list is static so the
 * list is initialized at class loading
 */
public class NormalDistRandomList {

    private static final double[] NOD_0_1 = new double[RandomNumber.FIXED_SIZE];

    static {
        Random rnd = new Random();
        rnd.setSeed(1);
        for (int i = 0; i < RandomNumber.FIXED_SIZE; i++) {
            NOD_0_1[i] = rnd.nextGaussian();
        }
    }

    /**
     *
     * @return the size of the pseudo random number list
     */
    public static int length() {
        return NOD_0_1.length;
    }

    /**
     *
     * @param index
     * @return a normally distributed random number std 1 and mean 0
     */
    public static double getValue(int index) {
        return NOD_0_1[index];
    }
}
