/*
    (c) 2002 - 2022 Juergen Nagel, Jan Hansen
    Northwest German Forest Research Station (https://www.nw-fva.de), 
    Grätzelstr. 2, 37079 Göttingen, Germany
    E-Mail: Jan.Hansen@nw-fva.de
 
    This file is part of the TreeGrOSS libraray.

    TreeGrOSS is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    TreeGrOSS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with TreeGrOSS. If not, see http://www.gnu.org/licenses/.
*/

package treegross.tools;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


/**
 *
 * @author jhansen
 */
public class XmlTool {
    
    
    public static Element addChild(Element toElt, String name) {      
        Element newElt = toElt.getOwnerDocument().createElement(name);       
        toElt.appendChild(newElt);
        return newElt;
    }

    public static Element addChildString(Element toElt, String name, String text) {
        // do not add empty nodes!
        if (text == null || text.length() == 0) {
            //System.out.println("NOT adding value is null " + name);
            return null;
        }
        Element newElt = toElt.getOwnerDocument().createElement(name);
        newElt.appendChild(toElt.getOwnerDocument().createTextNode(text));
        toElt.appendChild(newElt);
        return newElt;
    }

    public static Node getChild(Node n, String childName) {
        String childNameLower = childName.toLowerCase();
        NodeList modelNodes = n.getChildNodes();
        Node m;
        String nn;
        for (int j = 0; j < modelNodes.getLength(); j++) {
            m = modelNodes.item(j);
            if (m.getNodeType() == Node.ELEMENT_NODE) {
                nn = m.getNodeName().toLowerCase();
                if (nn.equals(childNameLower)) {
                    return m;
                }
            }
        }
        return null;
    }
    
    public static List<Node> getChilds(Node n, String childName) {
        if (n == null) {
            return null;
        }
        String childNameLower = childName.toLowerCase();
        NodeList modelNodes = n.getChildNodes();
        ArrayList<Node> nl = new ArrayList<>();
        String nn;
        Node m;
        for (int j = 0; j < modelNodes.getLength(); j++) {
            m = modelNodes.item(j);
            if (m.getNodeType() == Node.ELEMENT_NODE) {
                nn = m.getNodeName().toLowerCase();
                if (nn.equals(childNameLower)) {
                    nl.add(m);
                }
            }
        }
        return nl;
    }
    
    public static String getChildText(Node n, String childName, String defaultIfNull) {
        String result = XmlTool.getChildText(n, childName);
        return result == null ? defaultIfNull : result;
    }

    public static String getChildText(Node n, String childName) {
        if (n == null) {
            return null;
        }
        String result = null;
        Node cn = getChild(n, childName);
        if (cn != null) {
            String tc = cn.getTextContent();
            if (tc != null) {
                result = tc;
            }
        }
        return result;
    }
}
